/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.network.PositionResponseMessage;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class PositionRequestMessage
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<PositionRequestMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"findme", (String)"position_request"));
    public static StreamCodec<? super RegistryFriendlyByteBuf, PositionRequestMessage> CODEC = new StreamCodec<RegistryFriendlyByteBuf, PositionRequestMessage>(){

        public PositionRequestMessage decode(RegistryFriendlyByteBuf object) {
            return new PositionRequestMessage(ItemStack.parseOptional((HolderLookup.Provider)object.registryAccess(), (CompoundTag)Objects.requireNonNull(object.readNbt())));
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, PositionRequestMessage positionRequestMessage) {
            registryFriendlyByteBuf.writeNbt(positionRequestMessage.stack.saveOptional((HolderLookup.Provider)registryFriendlyByteBuf.registryAccess()));
        }
    };
    private ItemStack stack;

    public PositionRequestMessage(ItemStack stack) {
        this.stack = stack;
        TrackingList.trackItem(stack);
    }

    public PositionRequestMessage() {
    }

    public static List<BlockPos> getBlockPosInAABB(AABB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.minY; y < axisAlignedBB.maxY; y += 1.0) {
            for (double x = axisAlignedBB.minX; x < axisAlignedBB.maxX; x += 1.0) {
                for (double z = axisAlignedBB.minZ; z < axisAlignedBB.maxZ; z += 1.0) {
                    blocks.add(new BlockPos((int)x, (int)y, (int)z));
                }
            }
        }
        return blocks;
    }

    public static boolean compareItems(ItemStack first, ItemStack second) {
        if (FindMeMod.CONFIG.COMMON.IGNORE_ITEM_DAMAGE) {
            return ItemStack.isSameItem((ItemStack)first, (ItemStack)second);
        }
        return ItemStack.isSameItemSameComponents((ItemStack)first, (ItemStack)second);
    }

    public void handle(NetworkManager.PacketContext contextSupplier) {
        contextSupplier.queue(() -> {
            AABB box = new AABB(contextSupplier.getPlayer().blockPosition()).inflate((double)FindMeMod.CONFIG.COMMON.RADIUS_RANGE);
            ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
            for (BlockPos blockPos : PositionRequestMessage.getBlockPosInAABB(box)) {
                BlockEntity tileEntity = contextSupplier.getPlayer().level().getBlockEntity(blockPos);
                if (tileEntity == null || !FindMeMod.BLOCK_CHECKERS.stream().anyMatch(predicate -> predicate.test(tileEntity, this.stack))) continue;
                blockPosList.add(blockPos);
            }
            if (!blockPosList.isEmpty()) {
                NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)contextSupplier.getPlayer()), (CustomPacketPayload)new PositionResponseMessage(blockPosList));
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

