/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.shake;

import com.finderfeed.fdlib.ClientMixinHandler;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShake;
import com.finderfeed.fdlib.util.FDByteBufCodecs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdlib:position_screen_shake")
public class PositionedScreenShakePacket
extends FDPacket {
    public FDShakeData data;
    public Vec3 pos;
    public double maxDistance;

    public PositionedScreenShakePacket(FDShakeData data, Vec3 pos, double maxDistance) {
        this.data = data;
        this.pos = pos;
        this.maxDistance = maxDistance;
    }

    public PositionedScreenShakePacket(FriendlyByteBuf buf) {
        this.data = (FDShakeData)FDShakeData.STREAM_CODEC.decode((Object)buf);
        this.pos = (Vec3)FDByteBufCodecs.VEC3.decode((Object)buf);
        this.maxDistance = buf.readDouble();
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        FDShakeData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
        FDByteBufCodecs.VEC3.encode((Object)buf, (Object)this.pos);
        buf.writeDouble(this.maxDistance);
    }

    @Override
    public void clientAction(IPayloadContext context) {
        ClientMixinHandler.addShake(new PositionedScreenShake(this.data, this.pos, this.maxDistance));
    }

    @Override
    public void serverAction(IPayloadContext context) {
    }

    public static void send(ServerLevel serverLevel, FDShakeData data, Vec3 pos, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)radius, (CustomPacketPayload)new PositionedScreenShakePacket(data, pos, radius), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

