/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen.default_components.buttons.selector_button;

import com.finderfeed.fdlib.systems.screen.FDScreen;
import com.finderfeed.fdlib.systems.screen.ValueComponent;
import com.finderfeed.fdlib.systems.screen.default_components.buttons.OnFDButtonPress;
import com.finderfeed.fdlib.systems.screen.default_components.buttons.selector_button.SelectorButton;
import com.finderfeed.fdlib.systems.screen.default_components.misc.FDVerticalComponentContainer;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public abstract class MainSelectorButton<T>
extends ValueComponent<T> {
    protected Field field;
    protected T value;
    protected FDVerticalComponentContainer buttonContainer;
    protected float r = 0.25f;
    protected float g = 0.25f;
    protected float b = 0.25f;
    protected float a = 1.0f;

    public MainSelectorButton(Field field, FDScreen screen, String uniqueId) {
        super(screen, uniqueId, 0.0f, 0.0f, 0.0f, 12.0f);
        this.field = field;
    }

    @Override
    public void renderComponent(GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        if (this.isHovered()) {
            FDRenderUtil.fill(graphics.pose(), x, y, this.getWidth(), this.getHeight(), this.r + 0.05f, this.g + 0.05f, this.b + 0.05f, this.a);
        } else {
            FDRenderUtil.fill(graphics.pose(), x, y, this.getWidth(), this.getHeight(), this.r, this.g, this.b, this.a);
        }
        String str = this.valueToString(this.value);
        Font font = Minecraft.getInstance().font;
        float w = font.width(str);
        float mod = Mth.clamp((float)((this.getWidth() - 2.0f) / w), (float)0.0f, (float)1.0f);
        FDRenderUtil.renderCenteredText(graphics, x + this.getWidth() / 2.0f, y + 2.0f, mod, false, str, 0xFFFFFF);
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public boolean mouseClicked(double mx, double my, int button) {
        if (this.buttonContainer == null) {
            this.initChoiceButtons();
        } else {
            this.destroyChoiceButtons();
        }
        return true;
    }

    protected void initChoiceButtons() {
        if (this.buttonContainer == null) {
            List<T> objects = this.values();
            float btnHeight = this.getHeight();
            float sizeOfChoiceWindow = (float)Math.min(objects.size(), 3) * btnHeight;
            FDVerticalComponentContainer container = new FDVerticalComponentContainer(this.getScreen(), this.getUniqueId() + "_container", 0.0f, this.getHeight(), sizeOfChoiceWindow);
            int i = 0;
            for (T s : objects) {
                OnFDButtonPress press = (screen, button, mx, my) -> {
                    container.setRemoved(true);
                    this.setValue(((SelectorButton)button).value);
                    return true;
                };
                String name = this.valueToString(s);
                SelectorButton<T> button2 = new SelectorButton<T>(s, name, this.getScreen(), this.getUniqueId() + "_button_" + i, 0.0f, 0.0f, this.getWidth(), btnHeight, press);
                button2.r = (float)Mth.clamp((double)((double)this.r + 0.1 * (double)((i + 1) % 2)), (double)0.0, (double)1.0);
                button2.g = (float)Mth.clamp((double)((double)this.g + 0.1 * (double)((i + 1) % 2)), (double)0.0, (double)1.0);
                button2.b = (float)Mth.clamp((double)((double)this.b + 0.1 * (double)((i + 1) % 2)), (double)0.0, (double)1.0);
                container.getChildren().setAsChild(button2);
                ++i;
            }
            this.getChildren().setAsChild(container);
            this.buttonContainer = container;
        }
    }

    protected void destroyChoiceButtons() {
        if (this.buttonContainer != null) {
            this.buttonContainer.setRemoved(true);
            this.buttonContainer = null;
        }
    }

    @Override
    public boolean isMouseOver(float mx, float my) {
        if (this.buttonContainer != null) {
            return FDRenderUtil.isMouseInBounds(mx, my, 0.0f, 0.0f, this.getWidth(), this.getHeight() + this.buttonContainer.getHeight());
        }
        return super.isMouseOver(mx, my);
    }

    @Override
    public void onFocused(boolean state) {
        super.onFocused(state);
        if (!state) {
            this.destroyChoiceButtons();
        }
    }

    @Override
    public boolean isWidthFixed() {
        return false;
    }

    public abstract String valueToString(T var1);

    public abstract List<T> values();
}

