/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.screen;

import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.screen.FDScreen;
import com.finderfeed.fdlib.systems.screen.FDScreenComponent;
import com.finderfeed.fdlib.systems.screen.ValueComponent;
import com.finderfeed.fdlib.systems.screen.annotations.FDName;
import com.finderfeed.fdlib.systems.screen.annotations.VComponent;
import com.finderfeed.fdlib.systems.screen.default_components.misc.DraggableComponent;
import com.finderfeed.fdlib.systems.screen.default_components.misc.FDVerticalComponentContainer;
import com.finderfeed.fdlib.systems.screen.default_components.text.FDSimpleText;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FDEditorComponent
extends FDScreenComponent {
    public static float OFFSET = 2.0f;
    public static float DRAGGABLE_COMPONENT_HEIGHT = 10.0f;
    public FDScreenComponent editing;
    public List<Pair<Pair<Field, Object>, ValueComponent<?>>> valueComponents = new ArrayList();

    public FDEditorComponent(FDScreenComponent editing, FDScreen screen, String uniqueId, float x, float y) {
        super(screen, uniqueId, x, y, 0.0f, 0.0f);
        this.initialize(editing);
    }

    @Override
    public void renderComponent(GuiGraphics graphics, float x, float y, float mx, float my, float partialTicks) {
        FDRenderUtil.fill(graphics.pose(), x, y, this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.0f, 1.0f);
        FDRenderUtil.fill(graphics.pose(), x, y, this.getWidth(), DRAGGABLE_COMPONENT_HEIGHT, 0.5f, 0.5f, 0.5f, 1.0f);
    }

    private void initialize(FDScreenComponent editing) {
        float defaultWidth;
        this.editing = editing;
        this.valueComponents.clear();
        this.getChildren().removeAllChildren();
        List<FDHelpers.ClassFields> fields = FDHelpers.collectAllAnnotatedFieldsInClass(editing.getClass(), VComponent.class);
        int id = 0;
        float defaultOffset = OFFSET;
        float fullHeight = defaultOffset + DRAGGABLE_COMPONENT_HEIGHT;
        float componentContainerHeight = 100.0f;
        FDVerticalComponentContainer attributesContainer = new FDVerticalComponentContainer(this.getScreen(), this.getUniqueId() + "_attributes", defaultOffset, fullHeight, componentContainerHeight);
        float maxFixedWidth = defaultWidth = 100.0f;
        ArrayList nonFixedWidthComponents = new ArrayList();
        for (int i = fields.size() - 1; i >= 0; --i) {
            FDHelpers.ClassFields classFields = fields.get(i);
            for (int g = 0; g < classFields.fields().size(); ++g) {
                float width;
                ValueComponent<?> cmp;
                Constructor<ValueComponent<?>> constructor;
                Field field = classFields.fields().get(g);
                field.setAccessible(true);
                VComponent component = field.getAnnotation(VComponent.class);
                Class<ValueComponent<?>> clazz = component.value();
                boolean hasFieldContext = false;
                try {
                    constructor = clazz.getConstructor(FDScreen.class, String.class);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Constructor<ValueComponent<?>> fieldConstructor = clazz.getConstructor(Field.class, FDScreen.class, String.class);
                        constructor = fieldConstructor;
                        hasFieldContext = true;
                    }
                    catch (NoSuchMethodException e1) {
                        throw new RuntimeException("No constructor was found in value component class " + String.valueOf(clazz) + " with parameters:(Optional) Field, FDScreen, String", e1);
                    }
                }
                try {
                    cmp = !hasFieldContext ? constructor.newInstance(new Object[]{this.getScreen(), this.getUniqueId() + id}) : constructor.newInstance(new Object[]{field, this.getScreen(), this.getUniqueId() + id});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (cmp.isWidthFixed()) {
                    width = cmp.getWidth();
                    maxFixedWidth = Math.max(width, maxFixedWidth);
                } else {
                    width = defaultWidth;
                    nonFixedWidthComponents.add(cmp);
                }
                cmp.setWidth(width);
                MutableComponent name = Component.literal((String)field.getName());
                Annotation[] annotationArray = field.getAnnotation(FDName.class);
                if (annotationArray instanceof FDName) {
                    Annotation[] n = annotationArray;
                    name = Component.translatable((String)n.value());
                }
                for (Annotation annotation : field.getAnnotations()) {
                    cmp.applyOptions(this, annotation);
                }
                Object o = null;
                try {
                    o = field.get(editing);
                    this.setDefaultComponentValue(cmp, o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.valueComponents.add(new Pair(new Pair<Field, Object>(field, o), cmp));
                FDSimpleText text = new FDSimpleText(this.getScreen(), this.getUniqueId() + "_text" + id, 0.0f, 0.0f, (Component)name, 1.0f);
                maxFixedWidth = Math.max(maxFixedWidth, text.getWidth());
                attributesContainer.getChildren().setAsChild(text);
                attributesContainer.getChildren().setAsChild(cmp);
                ++id;
            }
        }
        for (FDScreenComponent fDScreenComponent : nonFixedWidthComponents) {
            fDScreenComponent.setWidth(maxFixedWidth);
        }
        attributesContainer.setWidth(attributesContainer.getWidth() + 4.0f);
        this.setWidth(attributesContainer.getWidth() + defaultOffset * 2.0f);
        this.setHeight(attributesContainer.getHeight() + fullHeight + defaultOffset);
        DraggableComponent component = new DraggableComponent(this, this.getScreen(), this.getUniqueId() + "_dragging", 0.0f, 0.0f, this.getWidth(), DRAGGABLE_COMPONENT_HEIGHT);
        this.getChildren().setAsChild(attributesContainer);
        this.getChildren().setAsChild(component);
    }

    @Override
    public void onChildWidthChanged(FDScreenComponent child, float previous, float current) {
        super.onChildWidthChanged(child, previous, current);
        this.setWidth(current + OFFSET * 2.0f);
    }

    @Override
    public void tick() {
        super.tick();
        for (Pair<Pair<Field, Object>, ValueComponent<?>> entry : this.valueComponents) {
            Field field = (Field)((Pair)entry.first).first;
            Object previousValue = ((Pair)entry.first).second;
            try {
                ValueComponent component = (ValueComponent)entry.second;
                Object currentValue = field.get(this.editing);
                if (currentValue != null && !currentValue.equals(previousValue) || previousValue != null && !previousValue.equals(currentValue)) {
                    this.setDefaultComponentValue(component, currentValue);
                    ((Pair)entry.first).second = currentValue;
                    continue;
                }
                Object val = component.getValue();
                try {
                    field.set(this.editing, val);
                    ((Pair)entry.first).second = val;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private <T> void setDefaultComponentValue(ValueComponent<T> component, Object defaultVal) {
        try {
            component.setValue(defaultVal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

