/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.multiblock;

import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.multiblock.MultiblockBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class MultiblockShape
implements Iterable<Pair<BlockState, BlockPos>> {
    private List<BlockPos> partOffsets = new ArrayList<BlockPos>(List.of(BlockPos.ZERO));
    private List<BlockState> states = new ArrayList<BlockState>();
    private int maxDistanceFromMainBlock;

    private MultiblockShape() {
    }

    public static Builder builder(BlockState mainstate) {
        return new Builder(mainstate);
    }

    public BlockState getMainState() {
        return this.states.getFirst();
    }

    public boolean isAPartOfShape(BlockState stateBeingChecked, BlockPos mainBlockPos, BlockPos checkPos) {
        BlockPos offset = checkPos.subtract((Vec3i)mainBlockPos);
        Direction direction = (Direction)stateBeingChecked.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        MultiblockBlock block = (MultiblockBlock)stateBeingChecked.getBlock();
        offset = block.rotateOffsetBack(offset, direction);
        return this.isAPartOfShape(offset);
    }

    public boolean isAPartOfShape(BlockPos offset) {
        return this.partOffsets.contains(offset);
    }

    public int getMaxDistanceFromMainBlock() {
        return this.maxDistanceFromMainBlock;
    }

    @Override
    @NotNull
    public Iterator<Pair<BlockState, BlockPos>> iterator() {
        return new ShapeIterator(this);
    }

    public static class Builder {
        private MultiblockShape shape = new MultiblockShape();

        public Builder(BlockState mainState) {
            this.shape.states.add(mainState);
        }

        public Builder addMultiblockPartOffset(BlockPos offset, BlockState state) {
            if (!state.is(this.shape.getMainState().getBlock())) {
                throw new RuntimeException("Cannot create a shape out of different blocks! Blowing up...");
            }
            this.shape.partOffsets.add(offset);
            this.shape.states.add((BlockState)state.setValue((Property)MultiblockBlock.MAIN_BLOCK, (Comparable)Boolean.valueOf(false)));
            this.shape.maxDistanceFromMainBlock = Math.max(this.shape.maxDistanceFromMainBlock, Math.max(Math.abs(offset.getX()), Math.max(Math.abs(offset.getY()), Math.abs(offset.getZ()))));
            return this;
        }

        public MultiblockShape build() {
            return this.shape;
        }
    }

    public static class ShapeIterator
    implements Iterator<Pair<BlockState, BlockPos>> {
        private MultiblockShape shape;
        private int currentIndex = 0;

        public ShapeIterator(MultiblockShape multiblockShape) {
            this.shape = multiblockShape;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.shape.partOffsets.size();
        }

        @Override
        public Pair<BlockState, BlockPos> next() {
            BlockState blockState = this.shape.states.get(this.currentIndex);
            BlockPos offset = this.shape.partOffsets.get(this.currentIndex);
            Pair<BlockState, BlockPos> pair = new Pair<BlockState, BlockPos>(blockState, offset);
            ++this.currentIndex;
            return pair;
        }
    }
}

