/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.config.packets;

import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdlib:update_all_configs")
public class JsonConfigSyncPacket
extends FDPacket {
    private List<String> names;
    private List<String> configs;

    public JsonConfigSyncPacket() {
        this.names = new ArrayList<String>();
        this.configs = new ArrayList<String>();
        for (JsonConfig entry : FDRegistries.CONFIGS) {
            if (entry.isClientside()) continue;
            this.names.add(FDRegistries.CONFIGS.getKey((Object)entry).toString());
            this.configs.add(entry.getLoadedJson());
        }
    }

    public JsonConfigSyncPacket(FriendlyByteBuf buf) {
        int i;
        int namesLen = buf.readInt();
        this.names = new ArrayList<String>();
        for (i = 0; i < namesLen; ++i) {
            this.names.add(buf.readUtf());
        }
        this.configs = new ArrayList<String>();
        for (i = 0; i < namesLen; ++i) {
            this.configs.add(buf.readUtf());
        }
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.names.size());
        for (String name : this.names) {
            buf.writeUtf(name);
        }
        for (String sconfig : this.configs) {
            buf.writeUtf(sconfig);
        }
    }

    @Override
    public void clientAction(IPayloadContext context) {
        for (int i = 0; i < this.names.size(); ++i) {
            JsonConfig config = (JsonConfig)FDRegistries.CONFIGS.get(ResourceLocation.parse((String)this.names.get(i)));
            if (config.isClientside()) continue;
            JsonObject object = JsonParser.parseString((String)this.configs.get(i)).getAsJsonObject();
            config.setLoadedJson(object);
            config.parseJson(object);
        }
    }

    @Override
    public void serverAction(IPayloadContext context) {
    }
}

