/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.projectiles.renderers;

import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_fireball.MalkuthFireballRenderer;
import com.finderfeed.fdbosses.content.projectiles.MalkuthPlayerFireIceBall;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Random;

public class MalkuthPlayerFireIceBallRenderer
extends EntityRenderer<MalkuthPlayerFireIceBall> {
    public MalkuthPlayerFireIceBallRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(MalkuthPlayerFireIceBall fireball, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light) {
        float b;
        float g;
        float r;
        float bi;
        float gi;
        float ri;
        matrices.pushPose();
        float scale = Math.clamp(((float)fireball.tickCount + pticks) / 5.0f, 0.0f, 1.0f);
        matrices.scale(scale, scale, scale);
        if (fireball.getAttackType().isFire()) {
            color = MalkuthEntity.getMalkuthAttackPreparationParticleColor(fireball.getAttackType());
            ri = Math.clamp(color.x * 1.5f, 0.0f, 1.0f);
            gi = Math.clamp(color.y * 1.5f, 0.0f, 1.0f);
            bi = Math.clamp(color.z * 1.5f, 0.0f, 1.0f);
            r = color.x;
            g = color.y;
            b = color.z;
        } else {
            color = MalkuthEntity.getMalkuthAttackPreparationParticleColor(fireball.getAttackType());
            r = 0.7f;
            g = 0.75f;
            b = 0.75f;
            ri = color.x;
            gi = color.y;
            bi = color.z;
        }
        Random random = new Random((long)fireball.getId() * 21L);
        int dir = random.nextInt(2) == 1 ? -1 : 1;
        int dir2 = random.nextInt(2) == 1 ? -1 : 1;
        float time = 20.0f * ((float)fireball.tickCount + pticks);
        float time1 = 5.0f * ((float)fireball.tickCount + pticks);
        matrices.translate(0.0f, fireball.getBbHeight() / 2.0f, 0.0f);
        matrices.mulPose(Axis.ZP.rotationDegrees(time * (float)dir));
        matrices.mulPose(Axis.XP.rotationDegrees(time1 * (float)dir2));
        MalkuthFireballRenderer.renderCube(matrices, src.getBuffer(RenderType.lightning()), 0.6f, r, g, b, 0.5f, 2);
        MalkuthFireballRenderer.renderCube(matrices, src.getBuffer(RenderType.lightning()), 0.9f, ri, gi, bi, 0.5f, 2);
        matrices.popPose();
    }

    public ResourceLocation getTextureLocation(MalkuthPlayerFireIceBall p_114482_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

