/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocatorEye<T extends EyeOfEnder>
extends Item {
    private TagKey<Structure> structureTagKey;
    private Supplier<EntityType<T>> eyeType;

    public LocatorEye(TagKey<Structure> structureTag, Supplier<EntityType<T>> eyeType) {
        super(new Item.Properties().stacksTo(64).rarity(Rarity.EPIC));
        this.structureTagKey = structureTag;
        this.eyeType = eyeType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ServerLevel serverlevel;
        BlockPos blockpos;
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        if (level instanceof ServerLevel && (blockpos = (serverlevel = (ServerLevel)level).findNearestMapStructure(this.structureTagKey, player.blockPosition(), 100, false)) != null) {
            EyeOfEnder eyeofender = (EyeOfEnder)this.eyeType.get().create(level);
            eyeofender.setPos(player.getX(), player.getY(0.5), player.getZ());
            eyeofender.setItem(itemstack);
            eyeofender.signalTo(blockpos);
            level.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, eyeofender.position(), GameEvent.Context.of((Entity)player));
            level.addFreshEntity((Entity)eyeofender);
            float f = Mth.lerp((float)level.random.nextFloat(), (float)0.33f, (float)0.5f);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 1.0f, f);
            itemstack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.swing(hand, true);
            return InteractionResultHolder.success((Object)itemstack);
        }
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public boolean isFoil(ItemStack p_41453_) {
        return true;
    }
}

