/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.arc_lightning;

import com.finderfeed.fdbosses.client.particles.arc_lightning.ArcLightningOptions;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ArcLightningParticle
extends Particle {
    private ArcLightningOptions options;
    private Vec3 end;
    private Vec3 oldEnd;
    public static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::getRendertypeLightningShader);
            RenderSystem.blendFunc((int)770, (int)771);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        }

        public boolean isTranslucent() {
            return true;
        }

        public String toString() {
            return "ARC_LIGHTNING_RENDER_TYPE";
        }
    };

    public ArcLightningParticle(ArcLightningOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.options = options;
        this.lifetime = options.lifetime;
        this.end = this.options.end;
        this.oldEnd = this.options.end;
        this.hasPhysics = false;
    }

    public void tick() {
        super.tick();
        this.oldEnd = this.end;
        this.end = this.end.add(this.options.endSpeed);
        this.setBoundingBox(new AABB(this.x, this.y, this.z, this.end.x, this.end.y, this.end.z));
    }

    public void render(VertexConsumer vertex, Camera camera, float partialTicks) {
        Vec3 pos = new Vec3(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x), Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y), Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z)).subtract(camera.getPosition());
        Vec3 endi = FDMathUtil.interpolateVectors((Vec3)this.oldEnd, (Vec3)this.end, (float)partialTicks);
        Vec3 between = endi.subtract(camera.getPosition()).subtract(pos);
        double horLen = Math.sqrt(between.x * between.x + between.z * between.z);
        double verticalLength = between.y;
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        positions.add(Vec3.ZERO);
        int circleSegmentsAmount = 10;
        float circleOffset = this.options.circleOffset;
        Vec3 end = new Vec3(horLen, verticalLength, 0.0);
        Vec3 b = end.normalize();
        Vec3 center = end.multiply(0.5, 0.5, 0.0);
        Vec3 circleCenter = center.add(b.zRot(-1.5707964f).multiply((double)circleOffset, (double)circleOffset, 0.0));
        Vec3 v1 = end.subtract(circleCenter);
        Vec3 v2 = circleCenter.reverse();
        double angle = circleOffset >= 0.0f ? (Math.PI * 2 - FDMathUtil.angleBetweenVectors((Vec3)v1, (Vec3)v2)) / (double)circleSegmentsAmount : FDMathUtil.angleBetweenVectors((Vec3)v1, (Vec3)v2) / (double)circleSegmentsAmount;
        Matrix4f rot = new Matrix4f().identity().rotateZ(-((float)angle));
        Vector4f v = new Vector4f((float)v2.x, (float)v2.y, 0.0f, 1.0f);
        for (int i = 0; i < circleSegmentsAmount - 1; ++i) {
            v = rot.transform(v);
            v.x /= v.w;
            v.y /= v.w;
            v.w = 1.0f;
            positions.add(new Vec3((double)v.x + circleCenter.x, (double)v.y + circleCenter.y, 0.0));
        }
        positions.add(end);
        int lightningCounts = this.options.lightningSegments;
        List<Vec3> path = ArcLightningParticle.buildPath(this.level.getGameTime(), this.options.lightningRandomSpread, this.options.seed, lightningCounts, positions);
        Matrix4f mat = new Matrix4f();
        mat.translate((float)pos.x, (float)pos.y, (float)pos.z);
        mat.rotateY(-((float)Math.atan2(between.z, between.x)));
        FDColor color = this.options.color;
        ArcLightningParticle.drawLightning(mat, vertex, path, positions, this.options.lightningWidth, color.r, color.g, color.b, 1.0f);
        mat.translate(0.0f, 0.0f, 0.001f);
        ArcLightningParticle.drawLightning(mat, vertex, path, positions, this.options.lightningWidth * 0.15f, 1.0f, 1.0f, 1.0f, 1.0f);
        mat.translate(0.0f, 0.0f, -0.002f);
        ArcLightningParticle.drawLightning(mat, vertex, path, positions, this.options.lightningWidth * 0.15f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void fullLightningImmediateDraw(long time, int seed, int lightningBreakCount, Matrix4f transform, List<Vec3> path, float lightningWidth, float lightningRandomSpread, float r, float g, float b, float a) {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder builder = RENDER_TYPE.begin(tesselator, Minecraft.getInstance().getTextureManager());
        List<Vec3> positions = ArcLightningParticle.buildPath(time, lightningRandomSpread, seed, lightningBreakCount, path);
        ArcLightningParticle.drawLightning(transform, (VertexConsumer)builder, positions, path, lightningWidth, r, g, b, a);
        BufferUploader.drawWithShader((MeshData)builder.build());
    }

    public static void fullLightningDraw(long time, int seed, int lightningBreakCount, Matrix4f transform, VertexConsumer vertexConsumer, List<Vec3> path, float lightningWidth, float lightningRandomSpread, float r, float g, float b, float a) {
        List<Vec3> positions = ArcLightningParticle.buildPath(time, lightningRandomSpread, seed, lightningBreakCount, path);
        ArcLightningParticle.drawLightning(transform, vertexConsumer, positions, path, lightningWidth, r, g, b, a);
    }

    public static void drawLightning(Matrix4f transform, VertexConsumer vertex, List<Vec3> path, List<Vec3> positions, float lightningWidth, float r, float g, float b, float a) {
        Vec3 previousCenteredVector = new Vec3(0.0, 1.0, 0.0);
        Vec3 prevPoint = null;
        double previousw = 0.0;
        for (int i = 1; i < path.size() - 1; ++i) {
            Vec3 p1 = path.get(i - 1);
            Vec3 p2 = path.get(i);
            Vec3 p3 = path.get(i + 1);
            Vec3 v1 = p2.subtract(p1);
            Vec3 v2 = p3.subtract(p2);
            double dot = v1.reverse().dot(v2);
            double angle = Math.acos(dot / (v1.length() * v2.length()));
            double sin = angle != 0.0 ? Math.sin(angle / 2.0) : 1.0;
            Vec3 v = ArcLightningParticle.findCenteredVector(v1, v2);
            if (v.dot(previousCenteredVector) < 0.0) {
                v = v.reverse();
            }
            double w = (double)lightningWidth / sin;
            vertex.addVertex(transform, (float)p1.x, (float)p1.y, 0.0f).setColor(r, g, b, i == 1 ? 0.0f : a);
            vertex.addVertex(transform, (float)(p1.x + previousCenteredVector.x * previousw), (float)(p1.y + previousCenteredVector.y * previousw), 0.0f).setColor(r, g, b, 0.0f);
            vertex.addVertex(transform, (float)(p2.x + v.x * w), (float)(p2.y + v.y * w), 0.0f).setColor(r, g, b, 0.0f);
            vertex.addVertex(transform, (float)p2.x, (float)p2.y, 0.0f).setColor(r, g, b, a);
            vertex.addVertex(transform, (float)p1.x, (float)p1.y, 0.0f).setColor(r, g, b, i == 1 ? 0.0f : a);
            vertex.addVertex(transform, (float)(p1.x - previousCenteredVector.x * previousw), (float)(p1.y - previousCenteredVector.y * previousw), 0.0f).setColor(r, g, b, 0.0f);
            vertex.addVertex(transform, (float)(p2.x - v.x * w), (float)(p2.y - v.y * w), 0.0f).setColor(r, g, b, 0.0f);
            vertex.addVertex(transform, (float)p2.x, (float)p2.y, 0.0f).setColor(r, g, b, a);
            prevPoint = p2;
            previousw = w;
            previousCenteredVector = v;
        }
        Vec3 lastPos = positions.getLast();
        vertex.addVertex(transform, (float)prevPoint.x, (float)prevPoint.y, 0.0f).setColor(r, g, b, a);
        vertex.addVertex(transform, (float)(prevPoint.x + previousCenteredVector.x * previousw), (float)(prevPoint.y + previousCenteredVector.y * previousw), 0.0f).setColor(r, g, b, 0.0f);
        vertex.addVertex(transform, (float)lastPos.x, (float)lastPos.y, 0.0f).setColor(r, g, b, 0.0f);
        vertex.addVertex(transform, (float)lastPos.x, (float)lastPos.y, 0.0f).setColor(r, g, b, a);
        vertex.addVertex(transform, (float)prevPoint.x, (float)prevPoint.y, 0.0f).setColor(r, g, b, a);
        vertex.addVertex(transform, (float)(prevPoint.x - previousCenteredVector.x * previousw), (float)(prevPoint.y - previousCenteredVector.y * previousw), 0.0f).setColor(r, g, b, 0.0f);
        vertex.addVertex(transform, (float)lastPos.x, (float)lastPos.y, 0.0f).setColor(r, g, b, 0.0f);
        vertex.addVertex(transform, (float)lastPos.x, (float)lastPos.y, 0.0f).setColor(r, g, b, a);
    }

    public static List<Vec3> buildPath(long time, float lightningRandomSpread, int seed, int lightningCounts, List<Vec3> positions) {
        float step = 1.0f / (float)lightningCounts;
        Random r = new Random(time * (long)seed);
        ArrayList<Vec3> path = new ArrayList<Vec3>();
        path.add(positions.get(0));
        float lightningSpread = lightningRandomSpread;
        for (float i = step; i <= 1.0f - step / 2.0f; i += step) {
            float gl = i * (float)(positions.size() - 1);
            float lp = gl - (float)((int)gl);
            Vec3 current = positions.get((int)gl);
            Vec3 next = positions.get((int)gl + 1);
            Vec3 b = next.subtract(current);
            Vec3 nb = b.normalize();
            float rmod = r.nextFloat() * lightningSpread * 2.0f - lightningSpread;
            Vec3 point = current.add(b.multiply((double)lp, (double)lp, 0.0)).add(nb.zRot(1.5707964f).multiply((double)rmod, (double)rmod, (double)rmod));
            path.add(point);
        }
        path.add(positions.getLast());
        return path;
    }

    private static Vec3 getDirectionFromPositions(Vec3[] positions, int index) {
        if (index >= positions.length - 1) {
            return positions[positions.length - 1].subtract(positions[positions.length - 2]);
        }
        if (index < 0) {
            return positions[1].subtract(positions[0]);
        }
        return positions[index + 1].subtract(positions[index]);
    }

    private static Vec3 findCenteredVector(Vec3 v1, Vec3 v2) {
        v1 = v1.reverse().normalize();
        v2 = v2.normalize();
        return v1.add(v2).normalize();
    }

    public ParticleRenderType getRenderType() {
        return RENDER_TYPE;
    }

    public static class Factory
    implements ParticleProvider<ArcLightningOptions> {
        @Nullable
        public Particle createParticle(ArcLightningOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new ArcLightningParticle(options, level, x, y, z, xd, yd, zd);
        }
    }
}

