/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.boss_screen.text_block_processors.BossConfigFloatValueProcessor;
import com.finderfeed.fdbosses.client.boss_screen.text_block_processors.MobEffectTextProcessor;
import com.finderfeed.fdbosses.client.overlay.ElectrifiedOverlay;
import com.finderfeed.fdbosses.client.overlay.MalkuthWeaknessOverlay;
import com.finderfeed.fdbosses.client.particles.FlameWithStoneParticle;
import com.finderfeed.fdbosses.client.particles.IceChunkParticle;
import com.finderfeed.fdbosses.client.particles.arc_lightning.ArcLightningParticle;
import com.finderfeed.fdbosses.client.particles.arc_preparation_particle.ArcAttackPreparationParticle;
import com.finderfeed.fdbosses.client.particles.chesed_attack_ray.ChesedAttackRayParticle;
import com.finderfeed.fdbosses.client.particles.malkuth_slash.MalkuthHorizontalSlashParticle;
import com.finderfeed.fdbosses.client.particles.rush_particle.RushParticle;
import com.finderfeed.fdbosses.client.particles.smoke_particle.BigSmokeParticle;
import com.finderfeed.fdbosses.client.particles.sonic_particle.SonicParticle;
import com.finderfeed.fdbosses.client.particles.square_preparation_particle.RectanglePreparationParticle;
import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticle;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_crystal.ChesedCrystalEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_mini_ray.ChesedMiniRayRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_one_shot_vertical_ray.ChesedOneShotVerticalRayRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_vertical_ray.ChesedVerticalRayAttackRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.falling_block.ChesedFallingBlockRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.flying_block_entity.FlyingBlockEntityRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.kinetic_field.ChesedKineticFieldRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ray_reflector.RayReflectorRenderer;
import com.finderfeed.fdbosses.content.entities.chesed_sword_buff.FlyingSwordRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_boulder.MalkuthBoulderRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon.MalkuthCannonProjectileRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon.MalkuthCannonRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_chain.MalkuthChainRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_crush.MalkuthCrushAttack;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake.MalkuthEarthquakeRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_fireball.MalkuthFireballRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_floor.MalkuthFloorRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_giant_sword.MalkuthGiantSwordSlashRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal.MalkuthRepairCrystalRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal.MalkuthRepairEntityRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_slash.MalkuthSlashRenderer;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_warrior.MalkuthWarriorEntity;
import com.finderfeed.fdbosses.content.projectiles.renderers.BlockProjectileRenderer;
import com.finderfeed.fdbosses.content.projectiles.renderers.MalkuthPlayerFireIceBallRenderer;
import com.finderfeed.fdbosses.ik_2d.InverseKinematics2BoneTransform;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossItems;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdbosses.init.BossTileEntities;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.BoneTransformationController;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.HeadBoneTransformation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDEntityRenderLayerOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDEntityRendererBuilder;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDEntityTransformation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.renderer.FDFreeEntityRenderer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDModelItemRenderer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDModelItemRendererOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockEntityRendererBuilder;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockEntityTransformation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.renderer.FDBlockRenderLayerOptions;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_parser.TextBlockProcessor;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_parser.TextBlockProcessors;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.NullEntityRenderer;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.joml.Random;
import org.joml.Vector3f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="fdbosses")
public class BossClientModEvents {
    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(FDModelItemRenderer.createExtensions((FDModelItemRendererOptions)FDModelItemRendererOptions.create().addModel(BossModels.CHESED, RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/chesed.png"))).addModel(BossModels.CHESED_CRYSTAL_LAYER, RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/chesed_crystals.png"))).setScale(ctx -> {
            if (ctx == ItemDisplayContext.GROUND) {
                return Float.valueOf(0.15f);
            }
            return Float.valueOf(0.25f);
        }).addRotation(itemDisplayContext -> {
            if (itemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                return Float.valueOf(180.0f);
            }
            if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                return Float.valueOf(40.0f);
            }
            if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                return Float.valueOf(-40.0f);
            }
            return Float.valueOf(0.0f);
        }).addTranslation(ctx -> {
            if (ctx == ItemDisplayContext.GUI) {
                return new Vector3f(0.1f, -0.1f, 0.0f);
            }
            if (ctx == ItemDisplayContext.GROUND) {
                return new Vector3f();
            }
            return new Vector3f(0.1f, 0.0f, 0.0f);
        })), new Item[]{BossItems.CHESED_TROPHY.get()});
        event.registerItem(FDModelItemRenderer.createExtensions((FDModelItemRendererOptions)FDModelItemRendererOptions.create().addModel(BossModels.MALKUTH_SCREEN, RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_screen.png"))).addModel(BossModels.MALKUTH_SCREEN, RenderType.text((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_screen_emissive.png"))).setScale(ctx -> {
            if (ctx == ItemDisplayContext.GROUND) {
                return Float.valueOf(0.15f);
            }
            return Float.valueOf(0.25f);
        }).addRotation(itemDisplayContext -> {
            if (itemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                return Float.valueOf(180.0f);
            }
            if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                return Float.valueOf(40.0f);
            }
            if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                return Float.valueOf(-40.0f);
            }
            return Float.valueOf(0.0f);
        }).addTranslation(ctx -> {
            if (ctx == ItemDisplayContext.GUI) {
                return new Vector3f(-0.2f, -0.1f, 0.0f);
            }
            if (ctx == ItemDisplayContext.GROUND) {
                return new Vector3f();
            }
            return new Vector3f(0.1f, 0.0f, 0.0f);
        })), new Item[]{BossItems.MALKUTH_TROPHY.get()});
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            TextBlockProcessors.register((ResourceLocation)FDBosses.location("effect"), (TextBlockProcessor)new MobEffectTextProcessor());
            TextBlockProcessors.register((ResourceLocation)FDBosses.location("config_float"), (TextBlockProcessor)new BossConfigFloatValueProcessor());
            FDBlockEntityTransformation baseTransform = (trophy, matrices, pticks) -> matrices.mulPose(Axis.YP.rotationDegrees((float)trophy.getAngleFromState()));
            FDBlockEntityTransformation chesedTransform = (trophy, matrices, pticks) -> {
                matrices.scale(0.3f, 0.3f, 0.3f);
                baseTransform.apply(trophy, matrices, pticks);
            };
            BlockEntityRenderers.register(BossTileEntities.CHESED_TROPHY.get(), (BlockEntityRendererProvider)FDBlockEntityRendererBuilder.builder().addLayer(FDBlockRenderLayerOptions.builder().model(BossModels.CHESED).renderType(RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/chesed.png"))).transformation(chesedTransform).build()).addLayer(FDBlockRenderLayerOptions.builder().model(BossModels.CHESED_CRYSTAL_LAYER).renderType((entity, pticks) -> RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/chesed_crystals.png"))).color((entity, pticks) -> new FDColor(1.0f, 1.0f, 1.0f, 1.0f)).transformation(chesedTransform).build()).build());
            FDBlockEntityTransformation malkuthTransform = (trophy, matrices, pticks) -> {
                matrices.scale(0.3f, 0.3f, 0.3f);
                baseTransform.apply(trophy, matrices, pticks);
            };
            BlockEntityRenderers.register(BossTileEntities.MALKUTH_TROPHY.get(), (BlockEntityRendererProvider)FDBlockEntityRendererBuilder.builder().addLayer(FDBlockRenderLayerOptions.builder().model(BossModels.MALKUTH_SCREEN).renderType(RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_screen.png"))).transformation(malkuthTransform).build()).addLayer(FDBlockRenderLayerOptions.builder().model(BossModels.MALKUTH_SCREEN).light(0xF000F0).renderType((entity, pticks) -> RenderType.text((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_screen_emissive.png"))).transformation(malkuthTransform).build()).build());
        });
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.HOTBAR, FDBosses.location("electrified"), (LayeredDraw.Layer)new ElectrifiedOverlay());
        event.registerBelow(VanillaGuiLayers.HOTBAR, FDBosses.location("malkuth_weakness"), (LayeredDraw.Layer)new MalkuthWeaknessOverlay());
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpecial(BossParticles.RUSH_PARTICLE.get(), (ParticleProvider)new RushParticle.Factory());
        event.registerSpriteSet(BossParticles.BIS_SMOKE.get(), BigSmokeParticle.Factory::new);
        event.registerSpriteSet(BossParticles.SONIC_PARTICLE.get(), SonicParticle.Factory::new);
        event.registerSpriteSet(BossParticles.FLAME_WITH_STONE.get(), FlameWithStoneParticle.Factory::new);
        event.registerSpriteSet(BossParticles.ICE_CHUNK.get(), IceChunkParticle.Factory::new);
        event.registerSpecial(BossParticles.ARC_LIGHTNING.get(), (ParticleProvider)new ArcLightningParticle.Factory());
        event.registerSpecial(BossParticles.CHESED_RAY_ATTACK.get(), (ParticleProvider)new ChesedAttackRayParticle.Factory());
        event.registerSpecial(BossParticles.MALKUTH_HORIZONTAL_SLASH.get(), (ParticleProvider)new MalkuthHorizontalSlashParticle.Factory());
        event.registerSpecial(BossParticles.ARC_ATTACK_PREPARATION_PARTICLE.get(), (ParticleProvider)new ArcAttackPreparationParticle.Factory());
        event.registerSpecial(BossParticles.RECTANGLE_PREPARATION_PARTICLE.get(), (ParticleProvider)new RectanglePreparationParticle.Factory());
        event.registerSpecial(BossParticles.STRIPE_PARTICLE.get(), (ParticleProvider)new StripeParticle.Factory());
    }

    @SubscribeEvent
    public static void addRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityRendererProvider warriorRenderer = FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_WARRIOR).renderType(RenderType.entityCutoutNoCull((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_warrior.png"))).addBoneController("head", (BoneTransformationController)new HeadBoneTransformation()).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_WARRIOR).renderType((entity, pticks) -> {
            if (((MalkuthAttackType)((Object)((Object)entity.getEntityData().get(MalkuthWarriorEntity.WARRIOR_TYPE)))).isFire()) {
                return RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_warrior_fire.png"));
            }
            return RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_warrior_ice.png"));
        }).light(0xF000F0).addBoneController("head", (BoneTransformationController)new HeadBoneTransformation()).build()).build();
        event.registerEntityRenderer(BossEntities.FIRE_MALKUTH_WARRIOR.get(), warriorRenderer);
        event.registerEntityRenderer(BossEntities.ICE_MALKUTH_WARRIOR.get(), warriorRenderer);
        event.registerEntityRenderer(BossEntities.MALKUTH_REPAIR_CRYSTAL.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_REPAIR_CRYSTAL).renderType(RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crystal_base.png"))).ignoreHurtOverlay(true).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_REPAIR_CRYSTAL).renderType((malkuthRepairCrystal, v) -> malkuthRepairCrystal.getCrystalType().isFire() ? RenderType.text((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crystal_fire.png")) : RenderType.text((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crystal_ice.png"))).ignoreHurtOverlay(true).light(0xF000F0).color((malkuthRepairCrystal, v) -> new FDColor(1.0f, 0.75f, 0.75f, 0.5f)).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_REPAIR_CRYSTAL).renderType((malkuthRepairCrystal, v) -> malkuthRepairCrystal.getCrystalType().isFire() ? RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crystal_fire.png")) : RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crystal_ice.png"))).ignoreHurtOverlay(true).light(0xF000F0).color((malkuthRepairCrystal, v) -> new FDColor(1.0f, 1.0f, 1.0f, 1.0f)).build()).freeRender((FDFreeEntityRenderer)new MalkuthRepairCrystalRenderer()).build());
        FDEntityTransformation platformTransform = (platform, matrices, v) -> {
            float time = (float)platform.tickCount + v;
            Random random = new Random((long)platform.getId() * 33L);
            int timeToRise = 20 + random.nextInt(10);
            float p = Math.clamp(((float)platform.tickCount + v) / (float)timeToRise, 0.0f, 1.0f);
            float platformFloat = FDEasings.easeIn((float)p) * (float)Math.sin(time / 25.0f + random.nextFloat() * (float)Math.PI * 2.0f) * 0.05f;
            float translation = -5.0f + 5.0f * FDEasings.easeOutBack((float)p) + platformFloat;
            float randomYRot = platform.getId() % 4 * 90;
            matrices.translate(0.0f, translation, 0.0f);
            matrices.mulPose(Axis.YP.rotationDegrees(randomYRot));
            int d = random.nextInt(2) == 1 ? -1 : 1;
            float someRot = (float)(-15 * d) + FDEasings.easeOutBack((float)p) * 15.0f * (float)d;
            matrices.mulPose(Axis.XN.rotationDegrees(someRot));
            matrices.mulPose(Axis.YN.rotationDegrees(someRot));
        };
        event.registerEntityRenderer(BossEntities.MALKUTH_PLATFORM.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_PLATFORM).renderType(RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_platform.png"))).transformation(platformTransform).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_PLATFORM).renderType(RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_platform_emissive.png"))).transformation(platformTransform).build()).shouldRender((malkuthPlatform, frustum, v, v1, v2) -> frustum.isVisible(new AABB(-5.0, -5.0, -5.0, 5.0, 5.0, 5.0).move(malkuthPlatform.position()))).build());
        event.registerEntityRenderer(BossEntities.MALKUTH_BOSS_SPAWNER.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_SPAWNER).transformation((malkuthBossSpawner, poseStack, v) -> poseStack.mulPose(Axis.YP.rotationDegrees(90.0f))).renderType(RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_boss_spawner_emissive.png"))).light(0xF000F0).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH_SPAWNER).transformation((malkuthBossSpawner, poseStack, v) -> poseStack.mulPose(Axis.YP.rotationDegrees(90.0f))).renderType(RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_boss_spawner_solid.png"))).build()).shouldRender((malkuthBossSpawner, frustum, v, v1, v2) -> malkuthBossSpawner.isActive()).build());
        event.registerEntityRenderer(BossEntities.MALKUTH_CANNON.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().renderType((entity, pticks) -> {
            if (entity.getCannonType().isFire()) {
                return RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_cannon.png"));
            }
            return RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_cannon_ice.png"));
        }).model(BossModels.MALKUTH_CANNON).ignoreHurtOverlay(true).build()).addLayer(FDEntityRenderLayerOptions.builder().renderType((entity, pticks) -> RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_cannon_emissive.png"))).renderCondition(m -> m.getCannonType().isFire()).model(BossModels.MALKUTH_CANNON).ignoreHurtOverlay(true).build()).freeRender((FDFreeEntityRenderer)new MalkuthCannonRenderer()).build());
        InverseKinematics2BoneTransform rightLegIK = new InverseKinematics2BoneTransform(Direction.Axis.Z, Direction.Axis.X, "leg_right_control_start", "leg_right_control_end", "leg_right", "leg_right_lower", "leg_right_boot", false);
        InverseKinematics2BoneTransform leftLegIK = new InverseKinematics2BoneTransform(Direction.Axis.Z, Direction.Axis.X, "leg_left_control_start", "leg_left_control_end", "leg_left", "leg_left_lower", "leg_left_boot", false);
        event.registerEntityRenderer(BossEntities.MALKUTH.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH).renderType(RenderType.entityCutoutNoCull((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_solid.png"))).addBoneController("head", (BoneTransformationController)new HeadBoneTransformation()).addBoneController("leg_right_holder", rightLegIK).addBoneController("leg_left_holder", leftLegIK).ignoreHurtOverlay(true).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.MALKUTH).renderType(RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_emissive.png"))).addBoneController("head", (BoneTransformationController)new HeadBoneTransformation()).addBoneController("leg_right_holder", rightLegIK).addBoneController("leg_left_holder", leftLegIK).ignoreHurtOverlay(true).light(0xF000F0).build()).build());
        event.registerEntityRenderer(BossEntities.MALKUTH_CRUSH.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().transformation((malkuthCrushAttack, poseStack, v) -> {
            Vec3i nrm = ((Direction)malkuthCrushAttack.getEntityData().get(MalkuthCrushAttack.DIRECTION)).getNormal();
            FDRenderUtil.applyMovementMatrixRotations((PoseStack)poseStack, (Vec3)new Vec3((double)nrm.getX(), (double)nrm.getY(), (double)nrm.getZ()));
        }).light(0xF000F0).model(BossModels.MALKUTH_CRUSH_ATTACK).renderType((malkuthCrushAttack, v) -> {
            if (malkuthCrushAttack.isBothFireAndIce()) {
                return RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crash.png"));
            }
            if (malkuthCrushAttack.isFire()) {
                return RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crush_fire.png"));
            }
            return RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/malkuth/malkuth_crush_ice.png"));
        }).build()).build());
        event.registerEntityRenderer(BossEntities.CHESED.get(), FDEntityRendererBuilder.builder().shouldRender((entity, frustum, x, y, z) -> true).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED).ignoreHurtOverlay(true).renderType(RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/chesed.png"))).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_CRYSTAL_LAYER).ignoreHurtOverlay(true).renderType((entity, pticks) -> RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/chesed_crystals.png"))).color((entity, pticks) -> new FDColor(1.0f, 1.0f, 1.0f, 0.0f)).renderCondition(chesedEntity -> true).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_CRYSTAL_LAYER).ignoreHurtOverlay(true).renderType((entity, pticks) -> RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/chesed_crystals.png"))).color((entity, pticks) -> new FDColor(1.0f, 1.0f, 1.0f, 1.0f)).renderCondition(chesedEntity -> true).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_INFLATED).ignoreHurtOverlay(true).renderType((entity, pticks) -> RenderType.entityTranslucentEmissive((ResourceLocation)FDBosses.location("textures/entities/chesed_white_tex.png"))).color((entity, pticks) -> {
            ChesedEntity e = entity;
            float alpha = FDMathUtil.lerp((float)e.drainPercentOld, (float)e.getMonolithDrainPercent(), (float)pticks) * 0.3f;
            return new FDColor(0.1f, 1.0f, 1.0f, alpha);
        }).renderCondition(entity -> entity.getMonolithDrainPercent() != 0.0f).build()).freeRender((FDFreeEntityRenderer)new ChesedRenderer()).build());
        event.registerEntityRenderer(BossEntities.CHESED_ELECTRIC_SPHERE.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_ELECTRIC_SPHERE).transformation((entity, matrices, pticks) -> {
            matrices.translate(0.0f, 0.5f, 0.0f);
            float time = (float)entity.tickCount + pticks;
            float md = 16.0f;
            float scale = Mth.clamp((float)(time / 20.0f), (float)0.0f, (float)1.0f) * ((float)Math.sin(time * 2.0f) / md + (1.0f - 1.0f / md));
            matrices.scale(scale, scale, scale);
        }).renderType(RenderType.entityTranslucentCull((ResourceLocation)FDBosses.location("textures/entities/electric_orb.png"))).build()).build());
        event.registerEntityRenderer(BossEntities.CHESED_CRYSTAL.get(), FDEntityRendererBuilder.builder().shouldRender((entity, frustum, x, y, z) -> true).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_CRYSTAL).renderCondition(entity -> true).transformation((entity, stack, partialTicks) -> {
            FDRenderUtil.applyMovementMatrixRotations((PoseStack)stack, (Vec3)((ChesedCrystalEntity)entity).getCrystalFacingDirection());
            stack.mulPose(FDRenderUtil.rotationDegrees((Vector3f)FDRenderUtil.YP(), (float)((float)entity.getId() * 42.343f)));
            stack.scale(3.2f, 3.0f, 3.2f);
        }).renderType(RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/chesed_crystal.png"))).build()).build());
        event.registerEntityRenderer(BossEntities.CHESED_MONOLITH.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_MONOLITH).renderType(RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/chesed_monolith.png"))).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_MONOLITH).renderType(RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/chesed_monolith_emissive.png"))).build()).build());
        event.registerEntityRenderer(BossEntities.CHESED_KINETIC_FIELD.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_KINETIC_FIELD).renderType(RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/kinetic_field_spear.png"))).build()).shouldRender((entity, frustum, v, v1, v2) -> true).freeRender((x$0, x$1, x$2, x$3, x$4, x$5) -> ChesedKineticFieldRenderer.render(x$0, x$1, x$2, x$3, x$4, x$5)).build());
        event.registerEntityRenderer(BossEntities.CHESED_BOSS_SPAWNER.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.BOSS_SPAWNER).renderType(RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/boss_spawner.png"))).renderCondition(entity -> ((BossSpawnerEntity)((Object)entity)).isActive()).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.BOSS_SPAWNER).renderType(RenderType.entityTranslucentCull((ResourceLocation)FDBosses.location("textures/entities/boss_spawner_crystals.png"))).renderCondition(entity -> ((BossSpawnerEntity)((Object)entity)).isActive()).color((entity, v) -> new FDColor(1.0f, 1.0f, 1.0f, 0.25f)).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.BOSS_SPAWNER_CRYSTAL_LAYER).renderType(RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/boss_spawner_crystals.png"))).renderCondition(entity -> ((BossSpawnerEntity)((Object)entity)).isActive()).build()).build());
        event.registerEntityRenderer(BossEntities.CHESED_RAY_REFLECTOR.get(), FDEntityRendererBuilder.builder().addLayer(FDEntityRenderLayerOptions.builder().transformation((reflector, poseStack, v) -> poseStack.scale(0.8f, 0.8f, 0.8f)).model(BossModels.CHESED_RAY_REFLECTOR).renderType((e, p) -> RenderType.entityCutout((ResourceLocation)FDBosses.location("textures/entities/chesed_ray_reflector.png"))).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_RAY_REFLECTOR).transformation((reflector, poseStack, v) -> poseStack.scale(0.8f, 0.8f, 0.8f)).renderType((e, p) -> RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/chesed_ray_reflector_crystals.png"))).color((entity, pticks) -> new FDColor(1.0f, 1.0f, 1.0f, 0.0f)).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_RAY_REFLECTOR).transformation((reflector, poseStack, v) -> poseStack.scale(0.8f, 0.8f, 0.8f)).renderType((e, p) -> RenderType.eyes((ResourceLocation)FDBosses.location("textures/entities/chesed_ray_reflector_crystals.png"))).color((entity, pticks) -> {
            float animTime = ((Animation)BossAnims.RAY_REFLECTOR_ACTIVATE.get()).getAnimTime();
            float t = FDMathUtil.lerp((float)entity.activeTickerO, (float)entity.getActiveTicker(), (float)pticks);
            float p = t / animTime;
            float r = FDMathUtil.lerp((float)0.5f, (float)0.3f, (float)p);
            float g = FDMathUtil.lerp((float)0.5f, (float)0.95f, (float)p);
            float b = FDMathUtil.lerp((float)0.5f, (float)1.0f, (float)p);
            if (entity.isActivating()) {
                float offsetTime = t - animTime / 2.0f;
                float t2 = Math.clamp(offsetTime / 10.0f, 0.0f, 1.0f);
                float p2 = (double)t2 <= 0.25 ? 1.0f - (float)Math.pow(4.0f * t2 - 1.0f, 2.0) : 1.0f - (float)Math.pow(1.335 * ((double)t2 - 0.25), 2.0);
                r = FDMathUtil.lerp((float)r, (float)1.0f, (float)p2);
                g = FDMathUtil.lerp((float)g, (float)1.0f, (float)p2);
                b = FDMathUtil.lerp((float)b, (float)1.0f, (float)p2);
            }
            return new FDColor(r, g, b, 1.0f);
        }).build()).addLayer(FDEntityRenderLayerOptions.builder().model(BossModels.CHESED_RAY_REFLECTOR).renderCondition(entity -> {
            int ticksToReveal = 3;
            float animTime = ((Animation)BossAnims.RAY_REFLECTOR_ACTIVATE.get()).getAnimTime();
            return (float)entity.getActiveTicker() > animTime - (float)ticksToReveal;
        }).transformation((reflector, poseStack, v) -> poseStack.scale(0.8f, 0.8f, 0.8f)).renderType((e, p) -> RenderType.entityTranslucent((ResourceLocation)FDBosses.location("textures/entities/chesed_ray_reflector_crosshair.png"))).color((entity, pticks) -> {
            int ticksToReveal = 3;
            float animTime = ((Animation)BossAnims.RAY_REFLECTOR_ACTIVATE.get()).getAnimTime();
            float t = Mth.clamp((float)((float)entity.getActiveTicker() + pticks - (animTime - (float)ticksToReveal)), (float)0.0f, (float)ticksToReveal);
            return new FDColor(0.3f, 0.95f, 1.0f, t / (float)ticksToReveal);
        }).build()).freeRender((FDFreeEntityRenderer)new RayReflectorRenderer()).build());
        event.registerEntityRenderer(BossEntities.EARTH_SHATTER.get(), EarthShatterRenderer::new);
        event.registerEntityRenderer(BossEntities.BLOCK_PROJECTILE.get(), BlockProjectileRenderer::new);
        event.registerEntityRenderer(BossEntities.CHESED_FALLING_BLOCK.get(), ChesedFallingBlockRenderer::new);
        event.registerEntityRenderer(BossEntities.FLYING_BLOCK.get(), FlyingBlockEntityRenderer::new);
        event.registerEntityRenderer(BossEntities.RADIAL_EARTHQUAKE.get(), NullEntityRenderer::new);
        event.registerEntityRenderer(BossEntities.EYE_OF_CHESED.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(BossEntities.EYE_OF_MALKUTH.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(BossEntities.CHESED_VERTICAL_RAY_ATTACK.get(), ChesedVerticalRayAttackRenderer::new);
        event.registerEntityRenderer(BossEntities.CHESED_ONE_SHOT_VERTICAL_RAY_ATTACK.get(), ChesedOneShotVerticalRayRenderer::new);
        event.registerEntityRenderer(BossEntities.CHESED_FIRE_TRAIL.get(), NullEntityRenderer::new);
        event.registerEntityRenderer(BossEntities.FLYING_SWORD.get(), FlyingSwordRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_SLASH.get(), MalkuthSlashRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_CHAIN.get(), MalkuthChainRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_CANNON_PROJECTILE.get(), MalkuthCannonProjectileRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_GIANT_SWORD.get(), MalkuthGiantSwordSlashRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_BOULDER.get(), MalkuthBoulderRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_EARTHQUAKE.get(), MalkuthEarthquakeRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_FLOOR.get(), MalkuthFloorRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_FIREBALL.get(), MalkuthFireballRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_PLAYER_FIREBALL.get(), MalkuthPlayerFireIceBallRenderer::new);
        event.registerEntityRenderer(BossEntities.MALKUTH_REPAIR_ENTITY.get(), MalkuthRepairEntityRenderer::new);
        event.registerEntityRenderer(BossEntities.CHESED_MINI_RAY.get(), ChesedMiniRayRenderer::new);
    }
}

