/*
 * Decompiled with CFR 0.152.
 */
package net.perpetualeve.fadingnightvision;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.config.ConfigSettings;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="fadingnightvision", dist={Dist.CLIENT})
public class FadingNightVision {
    public static final String MODID = "fadingnightvision";
    public static ConfigHandler CONFIG;
    public static ConfigEntry.DoubleValue NV_FADE_IN_TIME;
    public static ConfigEntry.DoubleValue NV_FADE_OUT_TIME;
    public static ConfigEntry.DoubleValue BL_FADE_IN_TIME;
    public static ConfigEntry.DoubleValue BL_FADE_OUT_TIME;
    public static KeyMapping KEY;
    public static float blindness;
    public static float visionProgress;
    public static boolean nvActive;
    public static boolean blActive;
    public static boolean logicEnabled;
    private static boolean pressed;

    public FadingNightVision(IEventBus bus, ModContainer modContainer) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        Config config = new Config(MODID);
        CONFIG = CarbonConfig.CONFIGS.createConfig(config, ConfigSettings.withConfigType((ConfigType)ConfigType.SERVER));
        ConfigSection values = new ConfigSection("values");
        NV_FADE_IN_TIME = values.addDouble("nightvision_fade_in_time", 3.0, new String[]{"how fast it should fade in"}).setMax(10.0).setMin(0.05);
        NV_FADE_OUT_TIME = values.addDouble("nightvision_fade_out_time", 1.4, new String[]{"how fast it should fade out"}).setMax(10.0).setMin(0.05);
        BL_FADE_IN_TIME = values.addDouble("blindess_fade_in_time", 1.0, new String[]{"how fast it should fade in"}).setMax(10.0).setMin(0.05);
        BL_FADE_OUT_TIME = values.addDouble("blindess_fade_out_time", 1.0, new String[]{"how fast it should fade out"}).setMax(10.0).setMin(0.05);
        config.add(values);
        CONFIG.register();
        NeoForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::keyRegister);
    }

    @SubscribeEvent
    public void clientTick(ClientTickEvent.Post e) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        this.nightVisionUpdate();
        this.blindnessUpdate();
        if (KEY.isDown() && !pressed) {
            logicEnabled = !logicEnabled;
            pressed = true;
        } else if (!KEY.isDown()) {
            pressed = false;
        }
    }

    public void keyRegister(RegisterKeyMappingsEvent event) {
        event.register(KEY);
    }

    public float nightVisionUpdate() {
        if (nvActive && logicEnabled) {
            nvActive = false;
            if (visionProgress >= 1.0f) {
                return 1.0f;
            }
            visionProgress = Math.min(visionProgress + 1.0f / (20.0f * ((Double)NV_FADE_IN_TIME.getValue()).floatValue()), 1.0f);
            return visionProgress;
        }
        visionProgress = Math.max(visionProgress - 1.0f / (20.0f * ((Double)NV_FADE_OUT_TIME.getValue()).floatValue()), 0.0f);
        return visionProgress;
    }

    public float blindnessUpdate() {
        if (blActive) {
            MobEffectInstance effect;
            blActive = false;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && (effect = player.getEffect(MobEffects.BLINDNESS)) != null && (double)effect.getDuration() < 20.0 * (Double)BL_FADE_OUT_TIME.getValue()) {
                blindness = Math.max(blindness - 1.0f / ((Double)BL_FADE_OUT_TIME.getValue()).floatValue(), 0.0f);
                return blindness;
            }
            blindness = Math.min(blindness + 1.0f / ((Double)BL_FADE_IN_TIME.getValue()).floatValue(), 20.0f);
            return blindness;
        }
        return blindness;
    }

    static {
        KEY = new KeyMapping("key.fadingnightvision.toggle_night_vision", 86, "key.categories.misc");
        blindness = 0.0f;
        visionProgress = 0.0f;
        nvActive = false;
        blActive = false;
        logicEnabled = true;
        pressed = false;
    }
}

