/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.minecraft.nbt.Tag;

public final class ClientCache {
    private static final Map<UUID, Map<String, Tag>> DATA = new HashMap<UUID, Map<String, Tag>>();
    private static final Map<UUID, Map<String, Integer>> TYPES = new HashMap<UUID, Map<String, Integer>>();

    public static void setAll(UUID id, Map<String, Tag> values, Map<String, Integer> types) {
        HashMap vcopy = new HashMap();
        values.forEach((k, t) -> vcopy.put(k, t.copy()));
        DATA.put(id, vcopy);
        TYPES.put(id, new HashMap<String, Integer>(types));
    }

    public static void set(UUID id, String name, Tag v) {
        DATA.computeIfAbsent(id, k -> new HashMap()).put(name, v.copy());
    }

    public static void setType(UUID id, String name, int ord) {
        Map<String, Tag> m;
        Integer old = TYPES.computeIfAbsent(id, k -> new HashMap()).put(name, ord);
        if ((old == null || old != ord) && (m = DATA.get(id)) != null) {
            m.remove(name);
        }
    }

    public static Tag get(UUID id, String name) {
        Map<String, Tag> m = DATA.get(id);
        if (m == null) {
            return null;
        }
        Tag t = m.get(name);
        return t == null ? null : t.copy();
    }

    public static Optional<EntitySerializerType> getType(UUID id, String name) {
        Integer i = (Integer)TYPES.getOrDefault(id, Map.of()).get(name);
        return i == null ? Optional.empty() : Optional.of(EntitySerializerType.values()[i]);
    }

    public static void remove(UUID id, String name) {
        Map<String, Integer> tm;
        Map<String, Tag> m = DATA.get(id);
        if (m != null) {
            m.remove(name);
        }
        if ((tm = TYPES.get(id)) != null) {
            tm.remove(name);
        }
    }
}

