/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.ai;

import net.liopyu.entityjs.builders.misc.MoveControlJSBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;

public class MoveControlJS
extends MoveControl {
    private final MoveControlJSBuilder builder;

    private String entityName() {
        return this.mob.getType().toString();
    }

    public MoveControlJS(Mob mob, MoveControlJSBuilder builder) {
        super(mob);
        this.builder = builder;
    }

    public void setOperation(MoveControl.Operation operation) {
        this.operation = operation;
    }

    public void setStrafeRight(float strafeRight) {
        this.strafeRight = strafeRight;
    }

    public void setStrafeForwards(float strafeForwards) {
        this.strafeForwards = strafeForwards;
    }

    public MoveControl.Operation getOperation() {
        return this.operation;
    }

    public float getStrafeRight() {
        return this.strafeRight;
    }

    public float getStrafeForwards() {
        return this.strafeForwards;
    }

    public void setSpeedModifier(double speedModifier) {
        this.speedModifier = speedModifier;
    }

    public double getWantedZ() {
        return this.wantedZ;
    }

    public double getWantedY() {
        return this.wantedY;
    }

    public double getWantedX() {
        return this.wantedX;
    }

    public Mob getMob() {
        return this.mob;
    }

    public boolean hasWanted() {
        if (this.builder.hasWanted != null) {
            Boolean obj = this.builder.hasWanted.test(this.mob);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for hasWanted from entity:" + this.entityName() + " Move Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.hasWanted();
    }

    public double getSpeedModifier() {
        if (this.builder.getSpeedModifier != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.getSpeedModifier.apply(this.mob), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for getSpeedModifier from entity:" + this.entityName() + " Move Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.getSpeedModifier();
    }

    public void setWantedPosition(double pX, double pY, double pZ, double pSpeed) {
        if (this.builder.setWantedPosition != null) {
            ContextUtils.SetWantedPositionContext context = new ContextUtils.SetWantedPositionContext(pX, pY, pZ, pSpeed);
            this.builder.setWantedPosition.accept(context);
        } else {
            super.setWantedPosition(pX, pY, pZ, pSpeed);
        }
    }

    public void strafe(float pForward, float pStrafe) {
        if (this.builder.strafe != null) {
            ContextUtils.StrafeContext context = new ContextUtils.StrafeContext(pForward, pStrafe);
            EntityJSHelperClass.consumerCallback(this.builder.strafe, context, "[EntityJS]: Error in " + this.entityName() + " Move Control builder for field: strafe.");
        } else {
            super.strafe(pForward, pStrafe);
        }
    }

    public void tick() {
        if (this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this.mob, "[EntityJS]: Error in " + this.entityName() + " Move Control builder for field: tick.");
        } else {
            super.tick();
        }
    }

    protected float rotlerp(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
        if (this.builder.rotlerp != null) {
            ContextUtils.RotLerpContext context = new ContextUtils.RotLerpContext(pSourceAngle, pTargetAngle, pMaximumChange);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.rotlerp.apply(context), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for rotlerp from entity:" + this.entityName() + " Move Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.rotlerp(pSourceAngle, pTargetAngle, pMaximumChange);
    }

    protected boolean isWalkable(float pRelativeX, float pRelativeZ) {
        if (this.builder.isWalkable != null) {
            ContextUtils.IsWalkableContext context = new ContextUtils.IsWalkableContext(pRelativeX, pRelativeZ);
            Object obj = this.builder.isWalkable.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isWalkable from entity:" + this.entityName() + " Move Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.isWalkable(pRelativeX, pRelativeZ);
    }
}

