/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.BaseNonAnimatableEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileAnimatableJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.ProjectileAnimatableJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.ProjectileEntityJS;
import net.liopyu.entityjs.item.ProjectileItemJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;

public class ProjectileItemBuilder
extends ItemBuilder {
    public final transient BuilderBase<?> parent;
    public transient boolean canThrow;
    public transient float projectileZ;
    public transient float projectileVelocity;
    public transient float projectileInaccuracy;

    public ProjectileItemBuilder(ResourceLocation i, BuilderBase<?> parent) {
        super(i);
        this.parent = parent;
        this.canThrow = false;
        this.projectileZ = 0.0f;
        this.projectileVelocity = 1.5f;
        this.projectileInaccuracy = 1.0f;
        this.baseTexture = i.getNamespace() + ":item/" + i.getPath();
    }

    public Item createObject() {
        return new ProjectileItemJS(this.createItemProperties(), this.parent){

            public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
                if (ProjectileItemBuilder.this.use != null && ProjectileItemBuilder.this.use.use(pLevel, pPlayer, pUsedHand)) {
                    ItemUtils.startUsingInstantly((Level)pLevel, (Player)pPlayer, (InteractionHand)pUsedHand);
                }
                if (ProjectileItemBuilder.this.canThrow) {
                    ItemStack $$3 = pPlayer.getItemInHand(pUsedHand);
                    if (!pLevel.isClientSide) {
                        float pZ = ProjectileItemBuilder.this.projectileZ;
                        float pVelocity = ProjectileItemBuilder.this.projectileVelocity;
                        float pInaccuracy = ProjectileItemBuilder.this.projectileInaccuracy;
                        BuilderBase<?> builderBase = ProjectileItemBuilder.this.parent;
                        if (builderBase instanceof BaseNonAnimatableEntityBuilder) {
                            BaseNonAnimatableEntityBuilder builder = (BaseNonAnimatableEntityBuilder)builderBase;
                            if (builder instanceof ProjectileEntityJSBuilder) {
                                ProjectileEntityJSBuilder newBuilder = projectileEntityJSBuilder = (ProjectileEntityJSBuilder)builder;
                                ProjectileEntityJS $$4 = new ProjectileEntityJS(newBuilder, (EntityType<? extends ThrowableItemProjectile>)((EntityType)newBuilder.get()), (LivingEntity)pPlayer, pLevel);
                                $$4.setItem($$3);
                                $$4.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), pZ, pVelocity, pInaccuracy);
                                pLevel.addFreshEntity((Entity)$$4);
                            }
                        } else {
                            projectileEntityJSBuilder = ProjectileItemBuilder.this.parent;
                            if (projectileEntityJSBuilder instanceof BaseEntityBuilder) {
                                BaseEntityBuilder builder = (BaseEntityBuilder)((Object)projectileEntityJSBuilder);
                                ProjectileAnimatableJSBuilder newBuilder = (ProjectileAnimatableJSBuilder)builder;
                                ProjectileAnimatableJS $$4 = new ProjectileAnimatableJS(newBuilder, (EntityType<? extends ThrowableItemProjectile>)((EntityType)newBuilder.get()), (LivingEntity)pPlayer, pLevel);
                                $$4.setItem($$3);
                                $$4.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), pZ, pVelocity, pInaccuracy);
                                pLevel.addFreshEntity((Entity)$$4);
                            }
                        }
                    }
                    pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
                    if (!pPlayer.getAbilities().instabuild) {
                        $$3.shrink(1);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)$$3, (boolean)pLevel.isClientSide());
                }
                return super.use(pLevel, pPlayer, pUsedHand);
            }
        };
    }

    @Info(value="Sets whether the item can be thrown.\n\n@param canThrow True if the item can be thrown, false otherwise.\n\nExample usage:\n```javascript\nitemBuilder.canThrow(true);\n```\n")
    public ItemBuilder canThrow(boolean canThrow) {
        this.canThrow = canThrow;
        return this;
    }

    @Info(value="Sets the Z offset for the projectile.\n\n@param projectileZ The Z offset for the projectile.\n\nExample usage:\n```javascript\nitemBuilder.projectileZ(0.5f);\n```\n")
    public ItemBuilder projectileZ(float projectileZ) {
        this.projectileZ = projectileZ;
        return this;
    }

    @Info(value="Sets the velocity of the projectile.\n\n@param projectileVelocity The velocity of the projectile.\n\nExample usage:\n```javascript\nitemBuilder.projectileVelocity(1.5f);\n```\n")
    public ItemBuilder projectileVelocity(float projectileVelocity) {
        this.projectileVelocity = projectileVelocity;
        return this;
    }

    @Info(value="Sets the inaccuracy of the projectile.\n\n@param projectileInaccuracy The inaccuracy of the projectile.\n\nExample usage:\n```javascript\nitemBuilder.projectileInaccuracy(0.1f);\n```\n")
    public ItemBuilder projectileInaccuracy(float projectileInaccuracy) {
        this.projectileInaccuracy = projectileInaccuracy;
        return this;
    }
}

