/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.client.living.CustomKubeJSEntityRenderer;
import net.liopyu.entityjs.client.living.model.CustomGeoLayerJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJSCustom;
import net.liopyu.entityjs.entities.living.entityjs.WrappedAnimatableEntity;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.implementation.ILivingEntityJS;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class CustomGeoLayerJS<T extends LivingEntity>
extends GeoRenderLayer<T> {
    public T entity;
    public final CustomGeoLayerJSBuilder<T> geoBuilder;
    public final CustomKubeJSEntityRenderer<T> renderer;
    public final CustomEntityJSBuilder builder;

    public CustomGeoLayerJS(CustomKubeJSEntityRenderer<T> entityRendererIn, CustomGeoLayerJSBuilder<T> geoBuilder, CustomEntityJSBuilder builder) {
        super(entityRendererIn);
        this.geoBuilder = geoBuilder;
        this.renderer = entityRendererIn;
        this.builder = builder;
    }

    public String entityName() {
        return ((EntityType)this.builder.get()).toString();
    }

    protected ResourceLocation getTextureResource(T animatable) {
        animatable = this.ensureIAnimatableJS((LivingEntity)animatable);
        if (this.geoBuilder.textureResource != null) {
            Object obj = this.geoBuilder.textureResource.apply(animatable);
            if (obj instanceof ResourceLocation) {
                ResourceLocation r = (ResourceLocation)obj;
                return r;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for textureResource in newGeoLayer builder. Value: " + String.valueOf(obj) + ". Must be a ResourceLocation. Defaulting to " + String.valueOf(super.getTextureResource(animatable)));
        }
        return super.getTextureResource(animatable);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        animatable = this.ensureIAnimatableJS((LivingEntity)animatable);
        if (this.geoBuilder.preRender != null && animatable != null) {
            ContextUtils.PreRenderContext<T> context = new ContextUtils.PreRenderContext<T>(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.geoBuilder.preRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: preRender");
            super.preRender(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        } else {
            super.preRender(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTicks, int packedLightIn, int packedOverlay) {
        animatable = this.ensureIAnimatableJS((LivingEntity)animatable);
        if (this.geoBuilder.render != null && animatable != null) {
            ContextUtils.PreRenderContext<T> context = new ContextUtils.PreRenderContext<T>(poseStack, animatable, bakedModel, renderType, bufferSource, buffer, partialTicks, packedLightIn, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.geoBuilder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render");
            RenderType renderLayer = RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureResource(animatable));
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderLayer, bufferSource.getBuffer(renderLayer), partialTicks, packedLightIn, OverlayTexture.NO_OVERLAY, this.getRenderer().getRenderColor(animatable, partialTicks, packedLightIn).argbInt());
        } else {
            RenderType renderLayer = RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureResource(animatable));
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderLayer, bufferSource.getBuffer(renderLayer), partialTicks, packedLightIn, OverlayTexture.NO_OVERLAY, this.getRenderer().getRenderColor(animatable, partialTicks, packedLightIn).argbInt());
        }
    }

    private T ensureIAnimatableJS(LivingEntity entity) {
        if (entity instanceof IAnimatableJSCustom) {
            IAnimatableJSCustom animatableJS = (IAnimatableJSCustom)entity;
            return (T)((LivingEntity)animatableJS);
        }
        if (entity instanceof ILivingEntityJS) {
            ILivingEntityJS iLivingEntityJS = (ILivingEntityJS)entity;
            return (T)iLivingEntityJS.entityJs$getAnimatableEntity();
        }
        return (T)new WrappedAnimatableEntity(entity, this.builder);
    }
}

