/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.screen;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sts15.enderdrives.client.ClientConfigCache;
import com.sts15.enderdrives.config.serverConfig;
import com.sts15.enderdrives.items.EnderDiskItem;
import com.sts15.enderdrives.network.NetworkHandler;
import com.sts15.enderdrives.screen.CustomImageButton;
import com.sts15.enderdrives.screen.CustomImageCycleButton;
import com.sts15.enderdrives.screen.FrequencyScope;
import com.sts15.enderdrives.screen.Particle2D;
import com.sts15.enderdrives.screen.TransferMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.joml.Matrix4f;

public class EnderDiskFrequencyScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"screen.enderdrives.frequency_selector");
    public static final int WINDOW_WIDTH = 176;
    public static final int WINDOW_HEIGHT = 105;
    private int leftPos;
    private int topPos;
    private static final int[] SELECTOR_X = new int[]{33, 83, 133};
    private static final int SELECTOR_Y = 37;
    private static final int ARROW_WIDTH = 8;
    private static final int ARROW_HEIGHT = 11;
    private static final int ARROW_SPRITE_SIZE = 16;
    private static final int[] ARROW_TOP_X = new int[]{30, 80, 130};
    private static final int ARROW_TOP_Y = 18;
    private static final int[] ARROW_BOTTOM_X = ARROW_TOP_X;
    private static final int ARROW_BOTTOM_Y = 63;
    private EditBox frequencyField;
    private static final int MAX_FREQUENCY = ClientConfigCache.freqMax;
    private static final int MIN_FREQUENCY = ClientConfigCache.freqMin;
    private int[] dyeIndices = new int[3];
    private int frequency;
    FrequencyScope currentScope;
    private boolean ftbTeamsLoaded = ModList.get().isLoaded("ftbteams");
    private final List<Particle2D> uiParticles = new ArrayList<Particle2D>();
    private float particleSpawnTimer = 0.0f;
    private final Random random = new Random();
    private int transferMode = 0;
    private CustomImageCycleButton transferButton;
    public static boolean useAltTheme = true;
    public static final int TEXT_COLOR = useAltTheme ? 16770124 : 0xFFFFFF;
    public static final int SHADOW_COLOR = useAltTheme ? 10043136 : 0xFFFFFF;

    private ResourceLocation getEnderDiskMask() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(useAltTheme ? "textures/gui/ender_disk_mask_alt.png" : "textures/gui/ender_disk_mask.png"));
    }

    private ResourceLocation getArrowUpHover() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(useAltTheme ? "textures/gui/up_arrow_highlight_alt.png" : "textures/gui/up_arrow_highlight.png"));
    }

    private ResourceLocation getArrowDownHover() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(useAltTheme ? "textures/gui/down_arrow_highlight_alt.png" : "textures/gui/down_arrow_highlight.png"));
    }

    private ResourceLocation getButtonTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(useAltTheme ? "textures/gui/scope_button_alt.png" : "textures/gui/scope_button.png"));
    }

    private ResourceLocation getButtonHoverTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)(useAltTheme ? "textures/gui/scope_button_hover_alt.png" : "textures/gui/scope_button_hover.png"));
    }

    public EnderDiskFrequencyScreen(int currentFrequency, FrequencyScope scope, int transferMode) {
        super((Component)Component.translatable((String)"screen.enderdrives.frequency"));
        this.frequency = currentFrequency;
        this.currentScope = scope;
        this.transferMode = transferMode;
        this.decodeFrequency();
    }

    protected void init() {
        if (!this.currentScope.isEnabled()) {
            this.currentScope = FrequencyScope.getDefault();
        }
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 105) / 2;
        int fieldX = this.leftPos + 9;
        int fieldY = this.topPos + 89;
        this.frequencyField = new EditBox(Minecraft.getInstance().font, fieldX, fieldY, 70, 12, (Component)Component.translatable((String)"screen.enderdrives.frequency_placeholder"));
        this.frequencyField.setMaxLength(4);
        this.frequencyField.setValue(String.valueOf(this.frequency));
        this.frequencyField.setResponder(this::onFrequencyFieldChanged);
        this.frequencyField.setBordered(false);
        this.frequencyField.setVisible(true);
        this.frequencyField.setTextColor(TEXT_COLOR);
        this.frequencyField.setTextShadow(true);
        this.frequencyField.setCanLoseFocus(true);
        this.addRenderableWidget((GuiEventListener)this.frequencyField);
        int transferButtonX = this.leftPos + (useAltTheme ? 102 : 100);
        this.transferButton = new CustomImageCycleButton(transferButtonX, this.topPos + 85, 15, 14, b -> {
            this.transferMode = TransferMode.next(this.transferMode);
            this.transferButton.setMode(this.transferMode);
        }, this.transferMode);
        this.addRenderableWidget((GuiEventListener)this.transferButton);
        int scopeButtonX = this.leftPos + (useAltTheme ? 120 : 118);
        CustomImageButton customButton = new CustomImageButton(scopeButtonX, this.topPos + 85, 50, 14, b -> this.cycleScope(), this.getButtonTexture(), this.getButtonHoverTexture(), this);
        this.addRenderableWidget((GuiEventListener)customButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderUIParticles(graphics, partialTick);
        this.drawColorSelectors(graphics);
        this.drawCustomBackground(graphics);
        this.drawTitle(graphics);
        this.drawArrowButtons(graphics, mouseX, mouseY);
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.frequencyField.getValue().isEmpty() && !this.frequencyField.isFocused()) {
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"screen.enderdrives.frequency_label"), this.frequencyField.getX() + 2, this.frequencyField.getY() + 2, TEXT_COLOR, false);
        }
        for (int i = 0; i < 3; ++i) {
            int topX = this.leftPos + ARROW_TOP_X[i];
            int topY = this.topPos + 18;
            int bottomX = this.leftPos + ARROW_BOTTOM_X[i];
            int bottomY = this.topPos + 63;
            int size = 16;
            if (this.isHovering(mouseX, mouseY, topX, topY, size, size)) {
                graphics.renderTooltip(this.font, (Component)Component.translatable((String)this.getTooltipText(i, true)), mouseX, mouseY);
                return;
            }
            if (!this.isHovering(mouseX, mouseY, bottomX, bottomY, size, size)) continue;
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)this.getTooltipText(i, false)), mouseX, mouseY);
            return;
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    private void cycleScope() {
        int nextId = (this.currentScope.id + 1) % 3;
        if (nextId == FrequencyScope.TEAM.id && !this.ftbTeamsLoaded) {
            nextId = 0;
        }
        this.currentScope = FrequencyScope.fromId(nextId);
    }

    private String getTooltipText(int index, boolean isTop) {
        int value = switch (index) {
            case 0 -> 256;
            case 1 -> 16;
            case 2 -> 1;
            default -> 0;
        };
        return isTop ? "screen.enderdrives.tooltip.plus_" + value : "screen.enderdrives.tooltip.minus_" + value;
    }

    private void drawCustomBackground(GuiGraphics graphics) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, -200.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.endPortal());
        Matrix4f matrix = graphics.pose().last().pose();
        int shaderX = this.leftPos + 8;
        int shaderY = this.topPos + 18;
        int shaderW = 162;
        int shaderH = 68;
        vertexConsumer.addVertex(matrix, (float)shaderX, (float)(shaderY + shaderH), 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)(shaderX + shaderW), (float)(shaderY + shaderH), 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f);
        vertexConsumer.addVertex(matrix, (float)(shaderX + shaderW), (float)shaderY, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f);
        vertexConsumer.addVertex(matrix, (float)shaderX, (float)shaderY, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f);
        bufferSource.endBatch(RenderType.endPortal());
        graphics.pose().popPose();
        graphics.blit(this.getEnderDiskMask(), this.leftPos, this.topPos, 0, 0, 176, 105);
    }

    private void renderUIParticles(GuiGraphics graphics, float partialTick) {
        float deltaTime = (float)Minecraft.getInstance().getFrameTimeNs() / 1.0E9f;
        this.particleSpawnTimer += deltaTime;
        while (this.particleSpawnTimer > 0.05f) {
            this.spawnParticle();
            this.particleSpawnTimer -= 0.05f;
        }
        int menuLeft = this.leftPos;
        int menuTop = this.topPos;
        int menuRight = this.leftPos + 176;
        int menuBottom = this.topPos + 105;
        this.uiParticles.removeIf(p -> !p.isAlive(menuLeft, menuTop, menuRight, menuBottom));
        for (Particle2D p2 : this.uiParticles) {
            p2.update(deltaTime);
            int alpha = (int)(255.0f * (1.0f - p2.age / p2.lifetime));
            int size = (int)p2.size;
            graphics.fill((int)p2.x, (int)p2.y, (int)p2.x + size, (int)p2.y + size, p2.getColor());
        }
    }

    private void spawnParticle() {
        int x;
        int centerX = this.leftPos + 88;
        int centerY = this.topPos + 52;
        int margin = 20;
        int screenW = this.width;
        int screenH = this.height;
        int y = switch (this.random.nextInt(4)) {
            case 0 -> {
                x = this.random.nextInt(this.leftPos - margin, this.leftPos + 176 + margin);
                yield this.random.nextInt(this.topPos - margin);
            }
            case 1 -> {
                x = this.random.nextInt(this.leftPos - margin, this.leftPos + 176 + margin);
                yield this.random.nextInt(this.topPos + 105 + margin, screenH);
            }
            case 2 -> {
                x = this.random.nextInt(this.leftPos - margin);
                yield this.random.nextInt(this.topPos, this.topPos + 105);
            }
            default -> {
                x = this.random.nextInt(this.leftPos + 176 + margin, screenW);
                yield this.random.nextInt(this.topPos, this.topPos + 105);
            }
        };
        float dx = centerX - x;
        float dy = centerY - y;
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        float speed = 40.0f + this.random.nextFloat() * 20.0f;
        float lifetime = dist / speed;
        this.uiParticles.add(new Particle2D(x, y, (dx /= dist) * speed, (dy /= dist) * speed, lifetime));
    }

    private void drawColorSelectors(GuiGraphics graphics) {
        for (int i = 0; i < 3; ++i) {
            int x = this.leftPos + SELECTOR_X[i] - 3;
            int y = this.topPos + 37 - 2;
            DyeColor dye = DyeColor.byId((int)this.dyeIndices[i]);
            int color = dye.getTextColor();
            this.fillRoundedRect(graphics, x, y, 16, 30, 3, FastColor.ARGB32.color((int)255, (int)color));
        }
    }

    private void fillRoundedRect(GuiGraphics graphics, int x, int y, int width, int height, int radius, int color) {
        graphics.fill(x + radius, y, x + width - radius, y + height, color);
        graphics.fill(x, y + radius, x + radius, y + height - radius, color);
        graphics.fill(x + width - radius, y + radius, x + width, y + height - radius, color);
        this.fillCircle(graphics, x + radius, y + radius, radius, color);
        this.fillCircle(graphics, x + width - radius - 1, y + radius, radius, color);
        this.fillCircle(graphics, x + radius, y + height - radius - 1, radius, color);
        this.fillCircle(graphics, x + width - radius - 1, y + height - radius - 1, radius, color);
    }

    private void fillCircle(GuiGraphics graphics, int centerX, int centerY, int radius, int color) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                if (dx * dx + dy * dy > radius * radius) continue;
                graphics.fill(centerX + dx, centerY + dy, centerX + dx + 1, centerY + dy + 1, color);
            }
        }
    }

    private void drawTitle(GuiGraphics graphics) {
        int titleX = this.leftPos + 12;
        int titleY = this.topPos + (useAltTheme ? 6 : 4);
        graphics.drawString(Minecraft.getInstance().font, TITLE, titleX, titleY, TEXT_COLOR, false);
    }

    private void drawArrowButtons(GuiGraphics graphics, int mouseX, int mouseY) {
        for (int i = 0; i < 3; ++i) {
            int topX = this.leftPos + ARROW_TOP_X[i];
            int topY = this.topPos + 18;
            int bottomX = this.leftPos + ARROW_BOTTOM_X[i];
            int bottomY = this.topPos + 63 + 1;
            if (this.isHovering(mouseX, mouseY, topX + 4, topY + 2, 8, 11)) {
                graphics.blit(this.getArrowUpHover(), topX, topY, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (!this.isHovering(mouseX, mouseY, bottomX + 4, bottomY + 2, 8, 11)) continue;
            graphics.blit(this.getArrowDownHover(), bottomX, bottomY, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int topX = this.leftPos + ARROW_TOP_X[i];
            int topY = this.topPos + 18;
            int bottomX = this.leftPos + ARROW_BOTTOM_X[i];
            int bottomY = this.topPos + 63;
            int hitboxSize = 16;
            if (this.isHovering((int)mouseX, (int)mouseY, topX, topY, 16, 16)) {
                this.dyeIndices[i] = (this.dyeIndices[i] + 1) % 16;
                this.updateFrequency();
                return true;
            }
            if (!this.isHovering((int)mouseX, (int)mouseY, bottomX, bottomY, 16, 16)) continue;
            this.dyeIndices[i] = (this.dyeIndices[i] - 1 + 16) % 16;
            this.updateFrequency();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isHovering(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void decodeFrequency() {
        this.dyeIndices[0] = this.frequency >> 8 & 0xF;
        this.dyeIndices[1] = this.frequency >> 4 & 0xF;
        this.dyeIndices[2] = this.frequency & 0xF;
    }

    private void updateFrequency() {
        int newFreq = this.dyeIndices[0] << 8 | this.dyeIndices[1] << 4 | this.dyeIndices[2];
        int min = (Integer)serverConfig.FREQ_MIN.get();
        int max = (Integer)serverConfig.FREQ_MAX.get();
        this.frequency = Math.max(min, Math.min(newFreq, max));
        if (this.frequencyField != null) {
            this.frequencyField.setValue(String.valueOf(this.frequency));
        }
    }

    private void onFrequencyFieldChanged(String text) {
        try {
            int value = Integer.parseInt(text);
            if (value < MIN_FREQUENCY || value > MAX_FREQUENCY) {
                return;
            }
            this.frequency = value;
            this.decodeFrequency();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void onClose() {
        ItemStack held;
        LocalPlayer player;
        super.onClose();
        int min = (Integer)serverConfig.FREQ_MIN.get();
        int max = (Integer)serverConfig.FREQ_MAX.get();
        int safeFreq = Math.max(min, Math.min(this.frequency, max));
        NetworkHandler.sendFrequencyUpdateToServer(safeFreq, this.currentScope, this.transferMode);
        if (this.currentScope == FrequencyScope.TEAM && (player = Minecraft.getInstance().player) != null && (held = player.getMainHandItem()).getItem() instanceof EnderDiskItem) {
            EnderDiskItem.updateTeamInfo(held, (Player)player);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void open(int currentFreq, FrequencyScope scope, int transferMode) {
        Minecraft.getInstance().setScreen((Screen)new EnderDiskFrequencyScreen(currentFreq, scope, transferMode));
    }
}

