/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.mixins;

import appeng.api.config.Actionable;
import appeng.api.config.OperationMode;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.StorageCell;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.blockentity.storage.IOPortBlockEntity;
import appeng.util.inv.AppEngInternalInventory;
import com.sts15.enderdrives.db.EnderDBManager;
import com.sts15.enderdrives.inventory.EnderDiskInventory;
import com.sts15.enderdrives.inventory.TapeDiskInventory;
import com.sts15.enderdrives.items.EnderDiskItem;
import com.sts15.enderdrives.items.TapeDiskItem;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IOPortBlockEntity.class})
public abstract class IOPortBlockEntityMixin {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger((String)"EnderDrives:IOPortMixin");
    @Shadow
    private AppEngInternalInventory inputCells;
    @Shadow
    private AppEngInternalInventory outputCells;
    @Shadow
    private IActionSource mySrc;
    @Unique
    private long enderdrives$lastSoundTick = 0L;
    @Unique
    private long enderdrives$lastMessageTick = 0L;

    @Invoker(value="transferContents")
    public abstract long invokeTransferContents(IGrid var1, StorageCell var2, long var3);

    @Inject(method={"transferContents"}, at={@At(value="HEAD")}, cancellable=true)
    private void patchTransfer(IGrid grid, StorageCell sourceInv, long toMove, CallbackInfoReturnable<Long> cir) {
        EnderDiskInventory ed;
        long rem;
        OperationMode mode = (OperationMode)((IOPortBlockEntity)this).getConfigManager().getSetting(Settings.OPERATION_MODE);
        if (sourceInv instanceof TapeDiskInventory) {
            TapeDiskInventory tape = (TapeDiskInventory)sourceInv;
            long rem2 = mode == OperationMode.EMPTY ? this.enderdrives$transferFromTapeToNetwork(grid, tape, toMove) : this.enderdrives$transferFromNetworkToTapeCell(grid, tape, toMove);
            cir.setReturnValue((Object)rem2);
            return;
        }
        if (sourceInv instanceof EnderDiskInventory && (rem = this.enderdrives$transferOneTypeSynced(grid, ed = (EnderDiskInventory)sourceInv, toMove)) < toMove) {
            cir.setReturnValue((Object)rem);
            return;
        }
        if (mode == OperationMode.EMPTY && !(sourceInv instanceof TapeDiskInventory)) {
            for (DriveBlockEntity drive : grid.getMachines(DriveBlockEntity.class)) {
                for (int slot = 0; slot < drive.getCellCount(); ++slot) {
                    TapeDiskInventory dest;
                    long rem3;
                    ItemStack ds = drive.getInternalInventory().getStackInSlot(slot);
                    if (!(ds.getItem() instanceof TapeDiskItem) || (rem3 = this.enderdrives$transferOneItemFromCellToTape(grid, sourceInv, dest = new TapeDiskInventory(ds), toMove)) >= toMove) continue;
                    cir.setReturnValue((Object)rem3);
                    return;
                }
            }
        }
    }

    @Unique
    private long enderdrives$transferFromTapeToNetwork(IGrid grid, TapeDiskInventory tape, long budget) {
        MEStorage net = grid.getStorageService().getInventory();
        IEnergyService en = grid.getEnergyService();
        KeyCounter kc = new KeyCounter();
        tape.getAvailableStacks(kc);
        for (Map.Entry e : kc) {
            long perOp;
            long use;
            long simExt;
            long have;
            AEKey key = (AEKey)e.getKey();
            long simIns = StorageHelper.poweredInsert((IEnergySource)en, (MEStorage)net, (AEKey)key, (long)(have = ((Long)e.getValue()).longValue()), (IActionSource)this.mySrc, (Actionable)Actionable.SIMULATE);
            if (simIns <= 0L || (simExt = tape.extract(key, use = Math.min(simIns, budget * (perOp = (long)key.getAmountPerOperation())), Actionable.SIMULATE, this.mySrc)) <= 0L) continue;
            long ext = tape.extract(key, simExt, Actionable.MODULATE, this.mySrc);
            long ins = StorageHelper.poweredInsert((IEnergySource)en, (MEStorage)net, (AEKey)key, (long)ext, (IActionSource)this.mySrc);
            if (ins < ext) {
                tape.insert(key, ext - ins, Actionable.MODULATE, this.mySrc);
            }
            return budget -= Math.max(1L, ins / perOp);
        }
        return budget;
    }

    @Unique
    private long enderdrives$transferFromNetworkToTapeCell(IGrid grid, TapeDiskInventory tape, long budget) {
        MEStorage net = grid.getStorageService().getInventory();
        IEnergyService en = grid.getEnergyService();
        KeyCounter kc = grid.getStorageService().getCachedInventory();
        for (Map.Entry e : kc) {
            long ext;
            long simIns;
            AEKey key = (AEKey)e.getKey();
            long have = (Long)e.getValue();
            if (have <= 0L || budget <= 0L) break;
            long perOp = key.getAmountPerOperation();
            long simExt = StorageHelper.poweredExtraction((IEnergySource)en, (MEStorage)net, (AEKey)key, (long)perOp, (IActionSource)this.mySrc, (Actionable)Actionable.SIMULATE);
            if (simExt <= 0L || (simIns = tape.insert(key, simExt, Actionable.SIMULATE, this.mySrc)) <= 0L || (ext = StorageHelper.poweredExtraction((IEnergySource)en, (MEStorage)net, (AEKey)key, (long)simIns, (IActionSource)this.mySrc, (Actionable)Actionable.MODULATE)) <= 0L) continue;
            long ins = tape.insert(key, ext, Actionable.MODULATE, this.mySrc);
            if (ins < ext) {
                StorageHelper.poweredInsert((IEnergySource)en, (MEStorage)net, (AEKey)key, (long)(ext - ins), (IActionSource)this.mySrc, (Actionable)Actionable.MODULATE);
            }
            return --budget;
        }
        return budget;
    }

    @Unique
    private long enderdrives$transferOneTypeSynced(IGrid grid, EnderDiskInventory src, long budget) {
        KeyCounter kc = new KeyCounter();
        src.getAvailableStacks(kc);
        if (kc.isEmpty()) {
            return budget;
        }
        MEStorage net = grid.getStorageService().getInventory();
        IEnergyService en = grid.getEnergyService();
        EnderDBManager.flushWALQueue();
        for (Map.Entry e : kc) {
            long ext;
            long simIns;
            long have;
            AEKey key = (AEKey)e.getKey();
            long simExt = src.extract(key, have = ((Long)e.getValue()).longValue(), Actionable.SIMULATE, this.mySrc);
            if (simExt <= 0L || (simIns = StorageHelper.poweredInsert((IEnergySource)en, (MEStorage)net, (AEKey)key, (long)simExt, (IActionSource)this.mySrc, (Actionable)Actionable.SIMULATE)) <= 0L || (ext = src.extract(key, simIns, Actionable.MODULATE, this.mySrc)) <= 0L) continue;
            long ins = StorageHelper.poweredInsert((IEnergySource)en, (MEStorage)net, (AEKey)key, (long)ext, (IActionSource)this.mySrc, (Actionable)Actionable.MODULATE);
            if (ins < ext) {
                src.insert(key, ext - ins, Actionable.MODULATE, this.mySrc);
            }
            long perOp = key.getAmountPerOperation();
            long used = Math.max(1L, ins / perOp);
            return budget - used;
        }
        return budget;
    }

    @Unique
    private long enderdrives$transferOneItemFromCellToTape(IGrid grid, StorageCell src, TapeDiskInventory dest, long budget) {
        IEnergyService en = grid.getEnergyService();
        KeyCounter kc = new KeyCounter();
        src.getAvailableStacks(kc);
        for (Map.Entry e : kc) {
            long ext;
            long simIns;
            AEKey key = (AEKey)e.getKey();
            long have = (Long)e.getValue();
            if (have <= 0L || budget <= 0L) break;
            long perOp = key.getAmountPerOperation();
            long simExt = src.extract(key, perOp, Actionable.SIMULATE, this.mySrc);
            if (simExt <= 0L || (simIns = dest.insert(key, simExt, Actionable.SIMULATE, this.mySrc)) <= 0L || (ext = src.extract(key, simIns, Actionable.MODULATE, this.mySrc)) <= 0L) continue;
            long ins = dest.insert(key, ext, Actionable.MODULATE, this.mySrc);
            if (ins < ext) {
                src.insert(key, ext - ins, Actionable.MODULATE, this.mySrc);
            }
            return --budget;
        }
        return budget;
    }

    @Inject(method={"tickingRequest"}, at={@At(value="HEAD")}, cancellable=true)
    private void enderdrives$preventSameFrequencyTransfer(IGridNode node, int ticksSinceLastCall, CallbackInfoReturnable<TickRateModulation> cir) {
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        Level level = ((IOPortBlockEntity)this).getLevel();
        BlockPos pos = ((IOPortBlockEntity)this).getBlockPos();
        for (DriveBlockEntity drive : grid.getMachines(DriveBlockEntity.class)) {
            for (int j = 0; j < drive.getCellCount(); ++j) {
                int i;
                ItemStack driveStack = drive.getInternalInventory().getStackInSlot(j);
                if (!(driveStack.getItem() instanceof EnderDiskItem)) continue;
                int driveFreq = EnderDiskItem.getFrequency(driveStack);
                String driveScope = EnderDiskItem.getSafeScopePrefix(driveStack);
                for (i = 0; i < this.inputCells.size(); ++i) {
                    ItemStack inputStack = this.inputCells.getStackInSlot(i);
                    if (!(inputStack.getItem() instanceof EnderDiskItem)) continue;
                    int inputFreq = EnderDiskItem.getFrequency(inputStack);
                    String inputScope = EnderDiskItem.getSafeScopePrefix(inputStack);
                    if (inputFreq != driveFreq || !inputScope.equals(driveScope)) continue;
                    this.enderdrives$playLoopWarning(level, pos);
                    cir.setReturnValue((Object)TickRateModulation.IDLE);
                    return;
                }
                for (i = 0; i < this.outputCells.size(); ++i) {
                    ItemStack outputStack = this.outputCells.getStackInSlot(i);
                    if (!(outputStack.getItem() instanceof EnderDiskItem)) continue;
                    int outputFreq = EnderDiskItem.getFrequency(outputStack);
                    String outputScope = EnderDiskItem.getSafeScopePrefix(outputStack);
                    if (outputFreq != driveFreq || !outputScope.equals(driveScope)) continue;
                    this.enderdrives$playLoopWarning(level, pos);
                    cir.setReturnValue((Object)TickRateModulation.IDLE);
                    return;
                }
            }
        }
    }

    @Unique
    private void enderdrives$playLoopWarning(Level level, BlockPos pos) {
        if (level == null || level.isClientSide) {
            return;
        }
        long gameTime = level.getGameTime();
        if (gameTime - this.enderdrives$lastSoundTick >= 60L) {
            level.playSound(null, pos, SoundEvents.ENDERMAN_STARE, SoundSource.BLOCKS, 0.6f, 0.6f + level.random.nextFloat() * 0.4f);
            this.enderdrives$lastSoundTick = gameTime;
        }
        if (gameTime - this.enderdrives$lastMessageTick >= 100L) {
            this.enderdrives$lastMessageTick = gameTime;
            Player nearestPlayer = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0, false);
            if (nearestPlayer != null) {
                nearestPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a75[EnderDrives] Transfer blocked: Infinite loop detected between linked drives."));
            }
        }
    }
}

