/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.pipeline;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.api.BlockRendererRegistry;
import org.embeddedt.embeddium.api.render.chunk.BlockRenderContext;
import org.embeddedt.embeddium.impl.Embeddium;
import org.embeddedt.embeddium.impl.model.color.ColorProvider;
import org.embeddedt.embeddium.impl.model.color.ColorProviderRegistry;
import org.embeddedt.embeddium.impl.model.light.LightMode;
import org.embeddedt.embeddium.impl.model.light.LightPipeline;
import org.embeddedt.embeddium.impl.model.light.LightPipelineProvider;
import org.embeddedt.embeddium.impl.model.light.data.QuadLightData;
import org.embeddedt.embeddium.impl.model.quad.BakedQuadView;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadOrientation;
import org.embeddedt.embeddium.impl.render.ShaderModBridge;
import org.embeddedt.embeddium.impl.render.chunk.ChunkColorWriter;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelVertexConsumer;
import org.embeddedt.embeddium.impl.render.chunk.compile.pipeline.BlockOcclusionCache;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevelHolder;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.DefaultMaterials;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.render.frapi.FRAPIModelUtils;
import org.embeddedt.embeddium.impl.render.frapi.FRAPIRenderHandler;
import org.embeddedt.embeddium.impl.render.frapi.IndigoBlockRenderContext;
import org.embeddedt.embeddium.impl.util.DirectionUtil;
import org.embeddedt.embeddium.impl.util.ModelQuadUtil;

public class BlockRenderer {
    private static final PoseStack EMPTY_STACK = new PoseStack();
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    private final ColorProviderRegistry colorProviderRegistry;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData quadLightData = new QuadLightData();
    private final LightPipelineProvider lighters;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final boolean useAmbientOcclusion;
    private final int[] quadColors = new int[4];
    private final List<BlockRendererRegistry.Renderer> customRenderers = new ObjectArrayList();
    private final FRAPIRenderHandler fabricModelRenderingHandler;
    private final ChunkColorWriter colorEncoder = ChunkColorWriter.get();
    private final boolean enableRenderPassOptimization;
    private static final int QUAD_FLAGS_NONE = 0;
    private static final int QUAD_REORIENTING = 1;
    private static final int QUAD_RENDER_PASS_OPTIMIZATION = 2;
    private static final int QUAD_FLAGS_ALL = 3;
    private int quadRenderingFlags = 0;

    public BlockRenderer(ColorProviderRegistry colorRegistry, LightPipelineProvider lighters) {
        this.colorProviderRegistry = colorRegistry;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.useAmbientOcclusion();
        this.fabricModelRenderingHandler = FRAPIRenderHandler.INDIGO_PRESENT ? new IndigoBlockRenderContext(this.occlusionCache, lighters.getLightData()) : null;
        this.enableRenderPassOptimization = Embeddium.options().performance.useRenderPassOptimization && !ShaderModBridge.areShadersEnabled();
    }

    public void renderModel(BlockRenderContext ctx, ChunkBuildBuffers buffers) {
        Material material = DefaultMaterials.forRenderLayer(ctx.renderLayer());
        ChunkModelBuilder meshBuilder = buffers.get(material);
        ColorProvider<BlockState> colorizer = this.colorProviderRegistry.getColorProvider(ctx.state().getBlock());
        LightMode mode = this.getLightingMode(ctx);
        LightPipeline lighter = this.lighters.getLighter(mode);
        Vec3 renderOffset = ctx.state().hasOffsetFunction() ? ctx.state().getOffset((BlockGetter)ctx.localSlice(), ctx.pos()) : Vec3.ZERO;
        this.customRenderers.clear();
        BlockRendererRegistry.instance().fillCustomRenderers(this.customRenderers, ctx);
        if (!this.customRenderers.isEmpty()) {
            for (BlockRendererRegistry.Renderer renderer : this.customRenderers) {
                try (ChunkModelVertexConsumer consumer = meshBuilder.asVertexConsumer(material);){
                    consumer.embeddium$setOffset(ctx.origin());
                    BlockRendererRegistry.RenderResult result = renderer.renderBlock(ctx, this.random, consumer);
                    if (result != BlockRendererRegistry.RenderResult.OVERRIDE) continue;
                    return;
                }
            }
        }
        if (FRAPIModelUtils.isFRAPIModel(ctx.model())) {
            this.fabricModelRenderingHandler.reset();
            this.fabricModelRenderingHandler.renderEmbeddium(ctx, buffers, ctx.stack(), this.random);
            return;
        }
        int nullCullfaceFlags = 3;
        for (Direction face : DirectionUtil.ALL_DIRECTIONS) {
            List<BakedQuad> quads = this.getGeometry(ctx, face);
            if (quads.isEmpty() || !this.isFaceVisible(ctx, face)) continue;
            this.quadRenderingFlags = 3;
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, buffers, meshBuilder, quads, face);
            nullCullfaceFlags &= this.quadRenderingFlags;
        }
        List<BakedQuad> list = this.getGeometry(ctx, null);
        if (!list.isEmpty()) {
            this.quadRenderingFlags = nullCullfaceFlags;
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, buffers, meshBuilder, list, null);
        }
    }

    private List<BakedQuad> getGeometry(BlockRenderContext ctx, Direction face) {
        RandomSource random = this.random;
        random.setSeed(ctx.seed());
        return ctx.model().getQuads(ctx.state(), face, random, ctx.modelData(), ctx.renderLayer());
    }

    private boolean isFaceVisible(BlockRenderContext ctx, Direction face) {
        return this.occlusionCache.shouldDrawSide(ctx.state(), (BlockGetter)ctx.localSlice(), ctx.pos(), face);
    }

    private static int computeLightFlagMask(BakedQuad quad) {
        int flag = 0;
        if (quad.hasAmbientOcclusion()) {
            flag |= 1;
        }
        if (quad.isShade()) {
            flag |= 2;
        }
        return flag;
    }

    private SpriteTransparencyLevel getQuadTransparencyLevel(BakedQuadView quad) {
        if ((quad.getFlags() & 0x20) == 0 || quad.getSprite() == null) {
            return SpriteTransparencyLevel.TRANSLUCENT;
        }
        return SpriteTransparencyLevelHolder.getTransparencyLevel(quad.getSprite());
    }

    private void checkQuadsHaveSameLightingConfig(List<BakedQuad> quads) {
        int quadsSize = quads.size();
        if (quadsSize >= 2) {
            int flagMask = -1;
            SpriteTransparencyLevel highestSeenLevel = SpriteTransparencyLevel.OPAQUE;
            for (int i = 0; i < quadsSize; ++i) {
                BakedQuad quad = quads.get(i);
                int newFlag = BlockRenderer.computeLightFlagMask(quad);
                if (flagMask == -1) {
                    flagMask = newFlag;
                } else if (newFlag != flagMask) {
                    this.quadRenderingFlags &= 0xFFFFFFFE;
                }
                SpriteTransparencyLevel seenLevel = this.getQuadTransparencyLevel((BakedQuadView)quad);
                if (seenLevel.ordinal() < highestSeenLevel.ordinal()) {
                    this.quadRenderingFlags &= 0xFFFFFFFD;
                    continue;
                }
                highestSeenLevel = seenLevel;
            }
        }
        if (!this.enableRenderPassOptimization) {
            this.quadRenderingFlags &= 0xFFFFFFFD;
        }
    }

    private ChunkModelBuilder chooseOptimalBuilder(Material defaultMaterial, ChunkBuildBuffers buffers, ChunkModelBuilder defaultBuilder, BakedQuadView quad) {
        if (defaultMaterial == DefaultMaterials.SOLID || (this.quadRenderingFlags & 2) == 0 || (quad.getFlags() & 0x20) == 0 || quad.getSprite() == null) {
            return defaultBuilder;
        }
        SpriteTransparencyLevel level = SpriteTransparencyLevelHolder.getTransparencyLevel(quad.getSprite().contents());
        if (level == SpriteTransparencyLevel.OPAQUE && defaultMaterial.pass.supportsFragmentDiscard()) {
            return buffers.get(DefaultMaterials.SOLID);
        }
        if (level == SpriteTransparencyLevel.TRANSPARENT && defaultMaterial == DefaultMaterials.TRANSLUCENT) {
            return buffers.get(DefaultMaterials.CUTOUT_MIPPED);
        }
        return defaultBuilder;
    }

    private void renderQuadList(BlockRenderContext ctx, Material material, LightPipeline lighter, ColorProvider<BlockState> colorizer, Vec3 offset, ChunkBuildBuffers buffers, ChunkModelBuilder defaultBuilder, List<BakedQuad> quads, Direction cullFace) {
        this.checkQuadsHaveSameLightingConfig(quads);
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuadView quad = (BakedQuadView)quads.get(i);
            QuadLightData lightData = this.getVertexLight(ctx, quad.hasAmbientOcclusion() ? lighter : this.lighters.getLighter(LightMode.FLAT), cullFace, quad);
            int[] vertexColors = this.getVertexColors(ctx, colorizer, quad);
            ChunkModelBuilder builder = this.chooseOptimalBuilder(material, buffers, defaultBuilder, quad);
            this.writeGeometry(ctx, builder, offset, material, quad, vertexColors, lightData);
            TextureAtlasSprite sprite = quad.getSprite();
            if (sprite == null) continue;
            builder.addSprite(sprite);
        }
    }

    private QuadLightData getVertexLight(BlockRenderContext ctx, LightPipeline lighter, Direction cullFace, BakedQuadView quad) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, ctx.pos(), light, cullFace, quad.getLightFace(), quad.hasShade());
        return light;
    }

    private int[] getVertexColors(BlockRenderContext ctx, ColorProvider<BlockState> colorProvider, BakedQuadView quad) {
        int[] vertexColors = this.quadColors;
        if (colorProvider != null && quad.hasColor()) {
            colorProvider.getColors(ctx.world(), ctx.pos(), ctx.state(), quad, vertexColors);
            int i = 0;
            while (i < vertexColors.length) {
                int n = i++;
                vertexColors[n] = vertexColors[n] | 0xFF000000;
            }
        } else {
            Arrays.fill(vertexColors, -1);
        }
        return vertexColors;
    }

    private void writeGeometry(BlockRenderContext ctx, ChunkModelBuilder builder, Vec3 offset, Material material, BakedQuadView quad, int[] colors, QuadLightData light) {
        ModelQuadOrientation orientation = (this.quadRenderingFlags & 1) != 0 ? ModelQuadOrientation.orientByBrightness(light.br, light.lm) : ModelQuadOrientation.NORMAL;
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        ModelQuadFacing normalFace = quad.getNormalFace();
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = ctx.origin().x() + quad.getX(srcIndex) + (float)offset.x();
            out.y = ctx.origin().y() + quad.getY(srcIndex) + (float)offset.y();
            out.z = ctx.origin().z() + quad.getZ(srcIndex) + (float)offset.z();
            out.color = this.colorEncoder.writeColor(ModelQuadUtil.mixARGBColors(colors[srcIndex], quad.getColor(srcIndex)), light.br[srcIndex]);
            out.u = quad.getTexU(srcIndex);
            out.v = quad.getTexV(srcIndex);
            out.light = ModelQuadUtil.mergeBakedLight(quad.getLight(srcIndex), light.lm[srcIndex]);
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
    }

    private LightMode getLightingMode(BlockRenderContext ctx) {
        boolean bl;
        block7: {
            block6: {
                BakedModel model = ctx.model();
                BlockState state = ctx.state();
                if (!this.useAmbientOcclusion) break block6;
                switch (model.useAmbientOcclusion(state, ctx.modelData(), ctx.renderLayer())) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case TRUE: {
                        break;
                    }
                    case DEFAULT: {
                        if (state.getLightEmission((BlockGetter)ctx.localSlice(), ctx.pos()) == 0) {
                            break;
                        }
                        break block6;
                    }
                    case FALSE: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        boolean canBeSmooth = bl;
        return canBeSmooth ? LightMode.SMOOTH : LightMode.FLAT;
    }
}

