/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.options;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.Window;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModList;
import org.embeddedt.embeddium.api.options.control.ControlValueFormatter;
import org.embeddedt.embeddium.api.options.control.SliderControl;
import org.embeddedt.embeddium.api.options.storage.MinecraftOptionsStorage;
import org.embeddedt.embeddium.api.options.structure.Option;
import org.embeddedt.embeddium.api.options.structure.OptionImpl;
import org.embeddedt.embeddium.api.options.structure.StandardOptions;

public class FullscreenResolutionHelper {
    public static boolean isFullscreenResAlreadyAdded() {
        return ModList.get().isLoaded("embeddium_extra") || ModList.get().isLoaded("rubidium_extra");
    }

    public static OptionImpl<?, ?> createFullScreenResolutionOption() {
        Window window = Minecraft.getInstance().getWindow();
        Monitor monitor = window.findBestMonitor();
        int maxMode = monitor != null ? monitor.getModeCount() - 1 : -1;
        ControlValueFormatter formatter = value -> {
            if (monitor == null) {
                return Component.translatable((String)"options.fullscreen.unavailable");
            }
            if (value == -1) {
                return Component.translatable((String)"options.fullscreen.current");
            }
            return Component.literal((String)monitor.getMode(value).toString());
        };
        return OptionImpl.createBuilder(Integer.TYPE, MinecraftOptionsStorage.INSTANCE).setId(StandardOptions.Option.FULLSCREEN_RESOLUTION).setName((Component)Component.translatable((String)"options.fullscreen.resolution")).setTooltip((Component)Component.translatable((String)"embeddium.options.fullscreen.resolution.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, -1, maxMode, 1, formatter)).setBinding((opts, value) -> {
            if (monitor != null) {
                window.setPreferredFullscreenVideoMode(value == -1 ? Optional.empty() : Optional.of(monitor.getMode(value.intValue())));
                window.changeFullscreenVideoMode();
            }
        }, opts -> monitor != null ? window.getPreferredFullscreenVideoMode().map(arg_0 -> ((Monitor)monitor).getVideoModeIndex(arg_0)).orElse(-1) : -1).build();
    }
}

