/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemBuildKey
extends BaseItemKey {
    public static final String REG_NAME = "item_key_build";
    public static final int BLOCKS_APART_PER_PLOT = 512;
    public static final float PLOT_ENTRANCE_OFFSET_X = 64.0f;
    public static final float PLOT_ENTRANCE_OFFSET_Z = 128.0f;

    public ItemBuildKey() {
        super(new Item.Properties().rarity(Rarity.COMMON));
    }

    public boolean isPlotBuilt(ItemStack stack) {
        if (stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            return ((DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)).built();
        }
        return false;
    }

    public void setPlotBuilt(ItemStack stack) {
        if (!stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            DimDungeons.logMessageError("ERROR: setting isBuilt on a non-key or an object without a dungeon key data component.");
            return;
        }
        DungeonKeyDataComponentRecord data = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA);
        DungeonKeyDataComponentRecord newData = new DungeonKeyDataComponentRecord(data.key_activated(), true, data.dest_x(), data.dest_z(), data.name_type(), data.name_part_1(), data.name_part_2(), data.theme(), data.dungeon_type());
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)newData);
    }

    @Override
    public float getWarpX(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            long dest_x = ((DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)).dest_x();
            return (float)(dest_x * 512L + 64L) + 64.0f;
        }
        return -1.0f;
    }

    @Override
    public float getWarpZ(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            long dest_z = ((DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)).dest_z();
            return (float)(dest_z * 512L + 64L) + 128.0f;
        }
        return -1.0f;
    }

    @Override
    public long getDungeonTopLeftX(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            long dest_x = ((DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)).dest_x();
            return dest_x * 512L;
        }
        return -1L;
    }

    @Override
    public long getDungeonTopLeftZ(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            long dest_z = ((DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)).dest_z();
            return dest_z * 512L;
        }
        return -1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(ItemStack stack) {
        if (ItemBuildKey.hasLegacyData(stack)) {
            return Component.translatable((String)"item.dimdungeons.item_legacy_key_name");
        }
        if (this.isActivated(stack)) {
            return Component.translatable((String)"item.dimdungeons.item_build_key");
        }
        return Component.translatable((String)"item.dimdungeons.item_build_key");
    }
}

