/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DungeonData
extends SavedData {
    private ConcurrentHashMap<ChunkPos, DungeonRoom> roomMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ChunkPos, DungeonRoom> remainingBuilds = new ConcurrentHashMap();
    private int numKeysRegistered = 0;
    private int ticksBetweenBuilds = 10;
    private static final String MY_DATA = "dungeon_data";

    @Nonnull
    public static DungeonData get(Level level) {
        if (level.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        if (!DungeonUtils.isDimensionDungeon(level)) {
            throw new RuntimeException("DungeonData is not supposed to exist in other dimensions! Calling this was probably unintended.");
        }
        DimensionDataStorage storage = ((ServerLevel)level).getDataStorage();
        return (DungeonData)storage.computeIfAbsent(new SavedData.Factory(DungeonData::create, DungeonData::load), MY_DATA);
    }

    public DungeonRoom getRoomAtPos(ChunkPos pos) {
        return this.roomMap.getOrDefault(pos, null);
    }

    public int getNumKeysRegistered() {
        return this.numKeysRegistered;
    }

    public boolean hasMoreRoomsToBuild() {
        return this.remainingBuilds.size() > 0;
    }

    public void notifyOfNewKeyActivation() {
        ++this.numKeysRegistered;
        this.setDirty();
    }

    public void registerNewRooms(DungeonDesigner layout, long x, long z) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                DungeonRoom nextRoom = layout.finalLayout[i][j];
                if (!nextRoom.hasRoom()) continue;
                ChunkPos cpos = new ChunkPos((int)x / 16 + i + 4, (int)z / 16 + j + 4);
                this.roomMap.computeIfAbsent(cpos, cp -> nextRoom);
                this.remainingBuilds.computeIfAbsent(cpos, cp -> nextRoom);
            }
        }
        this.setDirty();
    }

    public void tick(Level level) {
        --this.ticksBetweenBuilds;
        if (this.ticksBetweenBuilds <= 0 && this.remainingBuilds.size() > 0) {
            this.ticksBetweenBuilds = DungeonConfig.getDungeonBuildSpeed();
            ChunkPos cpos = (ChunkPos)((ConcurrentHashMap.KeySetView)this.remainingBuilds.keySet()).iterator().next();
            DungeonRoom nextBuild = this.remainingBuilds.get(cpos);
            this.remainingBuilds.remove(cpos);
            this.setDirty();
            DimDungeons.logMessageInfo("Now building room: " + nextBuild.structure);
            DungeonPlacement.buildRoomAtChunk(DungeonUtils.getDungeonWorld(level.getServer()), cpos);
        }
    }

    public DungeonData() {
        this.numKeysRegistered = 0;
    }

    public DungeonData(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag allRooms = tag.getList("room_data", (int)tag.getId());
        for (Object t : allRooms) {
            CompoundTag roomTag = (CompoundTag)t;
            ChunkPos pos = new ChunkPos(roomTag.getInt("x"), roomTag.getInt("z"));
            DungeonRoom room = new DungeonRoom();
            room.structure = roomTag.getString("structure");
            room.rotation = Rotation.valueOf((String)roomTag.getString("rotation"));
            room.roomType = DungeonDesigner.RoomType.valueOf(roomTag.getString("room_type"));
            room.dungeonType = DungeonDesigner.DungeonType.valueOf(roomTag.getString("dungeon_type"));
            this.roomMap.put(pos, room);
        }
        ListTag newBuilds = tag.getList("remaining_builds", (int)tag.getId());
        for (Tag t : newBuilds) {
            CompoundTag roomTag = (CompoundTag)t;
            ChunkPos pos = new ChunkPos(roomTag.getInt("x"), roomTag.getInt("z"));
            DungeonRoom room = new DungeonRoom();
            room.structure = roomTag.getString("structure");
            room.rotation = Rotation.valueOf((String)roomTag.getString("rotation"));
            room.roomType = DungeonDesigner.RoomType.valueOf(roomTag.getString("room_type"));
            room.dungeonType = DungeonDesigner.DungeonType.valueOf(roomTag.getString("dungeon_type"));
            this.remainingBuilds.put(pos, room);
        }
        CompoundTag totalKeyData = tag.getCompound("total_key_data");
        this.numKeysRegistered = totalKeyData.getInt("numKeysActivated");
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag allRooms = new ListTag();
        this.roomMap.forEach((chunkPos, room) -> {
            CompoundTag roomTag = new CompoundTag();
            roomTag.putInt("x", chunkPos.x);
            roomTag.putInt("z", chunkPos.z);
            roomTag.putString("structure", room.structure);
            roomTag.putString("rotation", room.rotation.toString());
            roomTag.putString("room_type", room.roomType.toString());
            roomTag.putString("dungeon_type", room.dungeonType.toString());
            roomTag.putInt("theme", room.theme);
            allRooms.add((Object)roomTag);
        });
        ListTag buildingRooms = new ListTag();
        this.remainingBuilds.forEach((chunkPos, room) -> {
            CompoundTag roomTag = new CompoundTag();
            roomTag.putInt("x", chunkPos.x);
            roomTag.putInt("z", chunkPos.z);
            roomTag.putString("structure", room.structure);
            roomTag.putString("rotation", room.rotation.toString());
            roomTag.putString("room_type", room.roomType.toString());
            roomTag.putString("dungeon_type", room.dungeonType.toString());
            roomTag.putInt("theme", room.theme);
            buildingRooms.add((Object)roomTag);
        });
        CompoundTag totalKeyData = new CompoundTag();
        totalKeyData.putInt("numKeysActivated", this.numKeysRegistered);
        tag.put("room_data", (Tag)allRooms);
        tag.put("remaining_builds", (Tag)buildingRooms);
        tag.put("total_key_data", (Tag)totalKeyData);
        return tag;
    }

    public static DungeonData create() {
        return new DungeonData();
    }

    public static DungeonData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        return new DungeonData(tag, lookupProvider);
    }
}

