/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TileEntityPortalKeyhole
extends BlockEntity {
    public static final String REG_NAME = "tileentity_portal_keyhole";
    private ItemStack objectInserted = ItemStack.EMPTY;
    private static final String ITEM_PROPERTY_KEY = "objectInserted";

    public TileEntityPortalKeyhole(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistrar.BE_PORTAL_KEYHOLE.get(), pos, state);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        TileEntityPortalKeyhole self = (TileEntityPortalKeyhole)((Object)blockEntity);
        ItemPortalKey key = (ItemPortalKey)self.getObjectInserted().getItem();
        DungeonGenData genData = DungeonGenData.Create().setKeyItem(self.getObjectInserted()).setDungeonType(key.getDungeonType(self.getObjectInserted())).setTheme(key.getDungeonTheme(self.getObjectInserted())).setReturnPoint(BlockPortalKeyhole.getReturnPoint(state, pos), DungeonUtils.serializeDimensionKey((ResourceKey<Level>)level.dimension()));
        if (!(genData.keyItem.getItem() instanceof ItemPortalKey)) {
            DimDungeons.logMessageError("FATAL ERROR: Using a non-key item to build a dungeon? What happened?");
            return;
        }
        if (!((Boolean)state.getValue((Property)BlockPortalKeyhole.IS_BUILDING)).booleanValue()) {
            DimDungeons.logMessageError("DIMDUNGEONS ERROR: Keyhole block ticked when it should not have.");
        } else if (!DungeonData.get((Level)DungeonUtils.getDungeonWorld(level.getServer())).hasMoreRoomsToBuild()) {
            DungeonUtils.openPortalAfterBuild(level, pos, genData, self);
            BlockState newBlockState = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockPortalKeyhole.FACING, (Comparable)((Direction)state.getValue((Property)BlockPortalKeyhole.FACING)))).setValue((Property)BlockPortalKeyhole.FILLED, (Comparable)Boolean.valueOf(self.isFilled()))).setValue((Property)BlockPortalKeyhole.LIT, (Comparable)Boolean.valueOf(self.isActivated()))).setValue((Property)BlockPortalKeyhole.IS_BUILDING, (Comparable)Boolean.valueOf(false));
            level.setBlockAndUpdate(pos, newBlockState);
        }
    }

    protected static int nextBuildStep(int currentStep, DungeonBuildSpeed speed) {
        if (speed == DungeonBuildSpeed.STOPPED) {
            return currentStep;
        }
        if (speed == DungeonBuildSpeed.SLOW) {
            return currentStep >= 650 ? 0 : currentStep + 1;
        }
        if (speed == DungeonBuildSpeed.NORMAL) {
            if (currentStep < 5) {
                return 5;
            }
            if (currentStep >= 650) {
                return 0;
            }
            return currentStep + 5;
        }
        if (speed == DungeonBuildSpeed.FASTEST) {
            if (currentStep < 10) {
                return 10;
            }
            if (currentStep >= 650) {
                return 0;
            }
            return currentStep + 10;
        }
        return 0;
    }

    public void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        if (compound.contains(ITEM_PROPERTY_KEY, 10)) {
            if (compound.getCompound(ITEM_PROPERTY_KEY).contains("id") && compound.getCompound(ITEM_PROPERTY_KEY).getString("id").equals("minecraft:air")) {
                DimDungeons.logMessageInfo("DIMDUNGEONS: Found a legacy keyhole with an air block inside of it. Fixing to be empty.");
                this.objectInserted = ItemStack.EMPTY;
                return;
            }
            this.objectInserted = ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound(ITEM_PROPERTY_KEY)).orElse(ItemStack.EMPTY);
            if (compound.getCompound(ITEM_PROPERTY_KEY).contains("tag")) {
                if (this.objectInserted.getItem() instanceof BaseItemKey) {
                    DimDungeons.logMessageInfo("DIMDUNGEONS: Found a legacy key inside a keyhole at load time. Trying to upgrade it now.");
                    DungeonKeyDataComponentRecord keydata = (DungeonKeyDataComponentRecord)this.objectInserted.get(DimDungeons.DUNGEON_KEY_DATA);
                    assert (keydata != null);
                    boolean key_activated = keydata.key_activated();
                    boolean built = keydata.built();
                    long dest_x = keydata.dest_x();
                    long dest_z = keydata.dest_z();
                    int name_type = keydata.name_type();
                    int name_part_1 = keydata.name_part_1();
                    int name_part_2 = keydata.name_part_2();
                    int theme = keydata.theme();
                    String dungeon_type = keydata.dungeon_type();
                    CompoundTag oldData = compound.getCompound(ITEM_PROPERTY_KEY).getCompound("tag");
                    if (oldData.contains("key_activated")) {
                        key_activated = oldData.getBoolean("key_activated");
                    }
                    if (oldData.contains("built")) {
                        built = oldData.getBoolean("built");
                    }
                    if (oldData.contains("dest_x")) {
                        dest_x = oldData.getLong("dest_x");
                    }
                    if (oldData.contains("dest_z")) {
                        dest_z = oldData.getLong("dest_z");
                    }
                    if (oldData.contains("name_type")) {
                        name_type = oldData.getInt("name_type");
                    }
                    if (oldData.contains("name_part_1")) {
                        name_part_1 = oldData.getInt("name_part_1");
                    }
                    if (oldData.contains("name_part_2")) {
                        name_part_2 = oldData.getInt("name_part_2");
                    }
                    if (oldData.contains("theme")) {
                        theme = oldData.getInt("theme");
                    }
                    if (oldData.contains("dungeon_type")) {
                        dungeon_type = oldData.getString("dungeon_type");
                    }
                    this.objectInserted.set(DimDungeons.DUNGEON_KEY_DATA, (Object)new DungeonKeyDataComponentRecord(key_activated, built, dest_x, dest_z, name_type, name_part_1, name_part_2, theme, dungeon_type));
                } else {
                    DimDungeons.logMessageError("DIMDUNGEONS: Found a legacy item (" + compound.getCompound(ITEM_PROPERTY_KEY).getString("id") + ") with NBT inside of keyhole while upgrading worlds. This is not supported.");
                    this.objectInserted = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound(ITEM_PROPERTY_KEY));
                }
            }
        } else {
            this.objectInserted = ItemStack.EMPTY;
        }
    }

    protected void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (this.isFilled() && !this.getObjectInserted().isEmpty()) {
            compound.put(ITEM_PROPERTY_KEY, this.getObjectInserted().save(registries));
        }
    }

    public boolean isFilled() {
        return !this.objectInserted.isEmpty();
    }

    public boolean isActivated() {
        ItemStack item = this.getObjectInserted();
        if (item.isEmpty()) {
            return false;
        }
        Item item2 = item.getItem();
        if (item2 instanceof BaseItemKey) {
            BaseItemKey key = (BaseItemKey)item2;
            return key.isActivated(item);
        }
        return false;
    }

    public ItemStack getObjectInserted() {
        if (BaseItemKey.hasLegacyData(this.objectInserted)) {
            BaseItemKey.convertLegacyData(this.objectInserted);
        }
        return this.objectInserted;
    }

    public void setContents(ItemStack item) {
        this.objectInserted = item;
        this.objectInserted.setCount(1);
        this.setChanged();
    }

    public void removeContents() {
        this.objectInserted = ItemStack.EMPTY;
        this.setChanged();
    }

    public static enum DungeonBuildSpeed {
        STOPPED,
        SLOW,
        NORMAL,
        FASTEST;

    }
}

