/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.PlayerDungeonEvents;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonChunkGenerator;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponent;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemBlankThemeKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.item.ItemSecretBell;
import com.catastrophe573.dimdungeons.item.SecretBellDataComponent;
import com.catastrophe573.dimdungeons.item.SecretBellDataComponentRecord;
import com.catastrophe573.dimdungeons.utils.CommandDimDungeons;
import com.catastrophe573.dimdungeons.utils.LootModifierNoDrops;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dimdungeons")
public class DimDungeons {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "dimdungeons";
    public static final String dungeon_dimension_regname = "dungeon_dimension";
    public static final String build_dimension_regname = "build_dimension";
    public static final ResourceKey<Level> DUNGEON_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"dungeon_dimension"));
    public static final ResourceKey<Level> BUILD_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"build_dimension"));
    private static final DeferredRegister<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATORS = DeferredRegister.create((ResourceLocation)Registries.CHUNK_GENERATOR.location(), (String)"dimdungeons");
    public static final DeferredHolder<MapCodec<? extends ChunkGenerator>, MapCodec<FlatLevelSource>> MY_CHUNK_GEN = CHUNK_GENERATORS.register("dimdungeons_chunkgen", () -> DungeonChunkGenerator.CODEC);
    public static final PlayerDungeonEvents eventHandler = new PlayerDungeonEvents();
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"dimdungeons");
    public static final Supplier<MapCodec<LootModifierNoDrops>> NO_DUNGEON_DROPS = GLOBAL_LOOT_MODIFIER_SERIALIZERS.register("no_dungeon_drops", () -> LootModifierNoDrops.CODEC);
    public static final DeferredRegister.DataComponents DATA_COMP_REGISTRAR = DeferredRegister.createDataComponents((String)"dimdungeons");
    public static final Supplier<DataComponentType<DungeonKeyDataComponentRecord>> DUNGEON_KEY_DATA = DATA_COMP_REGISTRAR.registerComponentType("dungeon_key_data", builder -> builder.persistent(DungeonKeyDataComponent.DUNGEON_KEY_DCR_CODEC));
    public static final Supplier<DataComponentType<SecretBellDataComponentRecord>> SECRET_BELL_DATA = DATA_COMP_REGISTRAR.registerComponentType("secret_bell_data", builder -> builder.persistent(SecretBellDataComponent.SECRET_BELL_DCR_CODEC));

    public DimDungeons(IEventBus modEventBus, Dist dist, ModContainer container) {
        BlockRegistrar.register(modEventBus);
        ItemRegistrar.register(modEventBus);
        CHUNK_GENERATORS.register(modEventBus);
        GLOBAL_LOOT_MODIFIER_SERIALIZERS.register(modEventBus);
        DATA_COMP_REGISTRAR.register(modEventBus);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::doCommonStuff);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::modConfig);
        NeoForge.EVENT_BUS.register((Object)eventHandler);
        NeoForge.EVENT_BUS.addListener(PlayerDungeonEvents::onWorldTick);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DungeonConfig.SERVER_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DungeonConfig.CLIENT_SPEC);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DungeonConfig.COMMON_SPEC, "dimdungeons-common-r200.toml");
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistrar.BLOCK_LOCAL_TELEPORTER.get()), (RenderType)RenderType.translucent());
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_PORTAL_KEY.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"keytype"), (stack, world, entity, number) -> ItemPortalKey.getKeyLevelAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_PORTAL_KEY.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"keytheme"), (stack, world, entity, number) -> ItemPortalKey.getKeyThemeAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_BLANK_THEME_KEY.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"keytheme"), (stack, world, entity, number) -> ItemBlankThemeKey.getKeyThemeAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_SECRET_BELL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"bellupgrade"), (stack, world, entity, number) -> ItemSecretBell.getUpgradeLevelAsFloat(stack));
            ItemProperties.register((Item)((Item)ItemRegistrar.ITEM_SECRET_BELL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"bellupgrade"), (stack, world, entity, number) -> ItemSecretBell.getUpgradeLevelAsFloat(stack));
        });
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDimDungeons.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public void modConfig(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (event instanceof ModConfigEvent.Unloading) {
            return;
        }
        if (config.getSpec() == DungeonConfig.CLIENT_SPEC) {
            DungeonConfig.refreshClient();
        } else if (config.getSpec() == DungeonConfig.SERVER_SPEC) {
            DungeonConfig.refreshServer();
        }
    }

    public static void logMessageInfo(String message) {
        if (DungeonConfig.logLevel.equalsIgnoreCase("all") || DungeonConfig.logLevel.equalsIgnoreCase("info")) {
            LOGGER.info(message);
        }
    }

    public static void logMessageWarn(String message) {
        if (DungeonConfig.logLevel.equalsIgnoreCase("all") || DungeonConfig.logLevel.equalsIgnoreCase("info") || DungeonConfig.logLevel.equalsIgnoreCase("warn")) {
            LOGGER.warn(message);
        }
    }

    public static void logMessageError(String message) {
        LOGGER.error(message);
    }
}

