/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.dialogue.DialogueChoice;
import com.cmdpro.databank.dialogue.DialogueInstance;
import com.cmdpro.databank.networking.Message;
import com.cmdpro.databank.registry.AttachmentTypeRegistry;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CloseDialogueC2SPacket() implements Message
{
    public static final CustomPacketPayload.Type<CloseDialogueC2SPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("close_dialogue_c2s"));

    public static CloseDialogueC2SPacket read(FriendlyByteBuf buf) {
        return new CloseDialogueC2SPacket();
    }

    public static void write(FriendlyByteBuf buf, CloseDialogueC2SPacket obj) {
    }

    public CustomPacketPayload.Type<CloseDialogueC2SPacket> type() {
        return TYPE;
    }

    @Override
    public void handleServer(MinecraftServer server, ServerPlayer player, IPayloadContext context) {
        ((Optional)player.getData(AttachmentTypeRegistry.CURRENT_DIALOGUE)).ifPresent(data -> {
            if (data.entry != null && data.entry.closeMenuChoice.isPresent()) {
                int choice = data.entry.closeMenuChoice.get();
                if (data.entry.choices.size() > choice && choice >= 0) {
                    DialogueChoice choiceInst = data.entry.choices.get(choice);
                    choiceInst.onClick((Player)player, (DialogueInstance)data, choiceInst);
                }
            }
        });
        player.setData(AttachmentTypeRegistry.CURRENT_DIALOGUE, Optional.empty());
    }
}

