/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.mixin.client;

import com.cmdpro.databank.misc.DatabankRenderLevelStages;
import com.cmdpro.databank.misc.ResizeHelper;
import com.cmdpro.databank.worldgui.WorldGuiEntity;
import com.cmdpro.databank.worldgui.WorldGuiHitResult;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Inject(method={"renderLevel"}, at={@At(value="TAIL")}, remap=false)
    private void Databank$renderLevel(DeltaTracker deltaTracker, CallbackInfo ci, @Local(name={"matrix4f"}) Matrix4f matrix4f, @Local(name={"matrix4f"}) Matrix4f matrix4f1, @Local(name={"camera"}) Camera camera) {
        Minecraft mc = Minecraft.getInstance();
        LevelRenderer levelRenderer = mc.levelRenderer;
        ClientHooks.dispatchRenderStage((RenderLevelStageEvent.Stage)DatabankRenderLevelStages.AFTER_HAND, (LevelRenderer)levelRenderer, null, (Matrix4f)matrix4f1, (Matrix4f)matrix4f, (int)levelRenderer.getTicks(), (Camera)camera, (Frustum)levelRenderer.getFrustum());
    }

    @Inject(method={"resize"}, at={@At(value="TAIL")}, remap=false)
    private void resize(int pWidth, int pHeight, CallbackInfo ci) {
        ResizeHelper.resize(pWidth, pHeight);
    }

    @Inject(method={"pick(Lnet/minecraft/world/entity/Entity;DDF)Lnet/minecraft/world/phys/HitResult;"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private void Databank$pick(Entity entity, double blockInteractionRange, double entityInteractionRange, float partialTick, CallbackInfoReturnable<HitResult> cir) {
        double distance;
        HitResult result = (HitResult)cir.getReturnValue();
        Vec3 vec3 = entity.getEyePosition(partialTick);
        double range = Math.min(entityInteractionRange, result.getLocation().distanceTo(vec3));
        Vec3 vec31 = entity.getViewVector(partialTick);
        Vec3 vec32 = vec3.add(vec31.x * range, vec31.y * range, vec31.z * range);
        Level level = entity.level();
        List guis = level.getEntitiesOfClass(WorldGuiEntity.class, AABB.ofSize((Vec3)entity.position(), (double)24.0, (double)24.0, (double)24.0));
        double closestDistance = -1.0;
        WorldGuiEntity closest = null;
        WorldGuiEntity.WorldGuiIntersectionResult closestResult = null;
        for (WorldGuiEntity i : guis) {
            WorldGuiEntity.WorldGuiIntersectionResult intersectionResult;
            if (i.guiType == null || i.gui == null || (intersectionResult = i.getLineIntersectResult(vec3, vec32)) == null) continue;
            Vec3 pos = intersectionResult.pos;
            double distance2 = vec3.distanceTo(pos);
            if (!(closestDistance < 0.0) && !(distance2 < closestDistance)) continue;
            closestDistance = distance2;
            closest = i;
            closestResult = intersectionResult;
        }
        if (closest != null && (distance = vec3.distanceTo(closestResult.pos)) < vec3.distanceTo(result.getLocation())) {
            WorldGuiHitResult hitResult = new WorldGuiHitResult(closest, closestResult.pos, closestResult);
            cir.setReturnValue((Object)hitResult);
        }
    }
}

