/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.megablock;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class MegablockRouter
extends Block {
    public static final Property<Direction> FACING = BlockStateProperties.FACING;

    public MegablockRouter(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.DOWN));
    }

    public abstract Block getCore();

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRotation.rotate((Direction)pState.getValue(FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue(FACING)));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockState blockState;
        BlockPos core;
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (state.getBlock() != newState.getBlock() && (core = this.findCore(level, pos.relative((Direction)state.getValue(FACING)))) != null && (blockState = level.getBlockState(core)).is(this.getCore())) {
            level.destroyBlock(core, true);
        }
    }

    public BlockPos findCore(Level level, BlockPos pos) {
        ArrayList<BlockPos> visited = new ArrayList<BlockPos>();
        BlockPos blockPos = pos;
        boolean valid = false;
        while (!visited.contains(blockPos)) {
            visited.add(blockPos);
            BlockState state2 = level.getBlockState(blockPos);
            if (state2.is((Block)this)) {
                blockPos = blockPos.relative((Direction)state2.getValue(FACING));
                continue;
            }
            if (!state2.is(this.getCore())) break;
            valid = true;
            break;
        }
        if (valid) {
            return blockPos;
        }
        return null;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && this.findCore((Level)(serverLevel = (ServerLevel)level), pos) == null) {
            return false;
        }
        return super.canSurvive(state, level, pos);
    }

    public Vec3i findOffset(Level level, BlockPos pos) {
        BlockPos core = this.findCore(level, pos);
        if (core == null) {
            return null;
        }
        return pos.subtract((Vec3i)core);
    }
}

