/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.dialogue;

import com.cmdpro.databank.dialogue.DialogueInstance;
import com.cmdpro.databank.dialogue.DialogueStyle;
import com.cmdpro.databank.dialogue.styles.DialogueStyleManager;
import com.cmdpro.databank.networking.ModMessages;
import com.cmdpro.databank.networking.packet.CloseDialogueC2SPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DialogueScreen
extends Screen {
    public DialogueInstance instance;

    public DialogueScreen(DialogueInstance instance) {
        super((Component)Component.empty());
        this.instance = instance;
        if (instance != null && instance.entry != null && instance.entry.style != null) {
            DialogueStyleManager.styles.get(instance.entry.style).changeEntry(instance, null, instance.entry.id);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.instance != null && this.instance.entry != null && this.instance.entry.style != null && DialogueStyleManager.styles.get(this.instance.entry.style).mouseClick(this.instance, mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.instance != null && this.instance.entry != null && this.instance.entry.style != null && DialogueStyleManager.styles.get(this.instance.entry.style).mouseDrag(this.instance, mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.instance != null && this.instance.entry != null && this.instance.entry.style != null && DialogueStyleManager.styles.get(this.instance.entry.style).mouseRelease(this.instance, mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void changeEntry(String from, String to) {
        if (this.instance != null && this.instance.entry != null && this.instance.entry.style != null) {
            DialogueStyleManager.styles.get(this.instance.entry.style).changeEntry(this.instance, from, to);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.instance != null && this.instance.entry != null && this.instance.entry.style != null) {
            DialogueStyle.render(this.instance.entry.style, this.instance, guiGraphics, mouseX, mouseY);
        }
    }

    public void tick() {
        super.tick();
        if (this.instance != null) {
            double last = this.instance.ticksOnEntry;
            this.instance.ticksOnEntry = this.instance.ticksOnEntry + (this.instance.entry != null ? this.instance.entry.speed : 1.0);
            if (this.instance.entry != null && this.instance.entry.style != null) {
                DialogueStyleManager.styles.get(this.instance.entry.style).tick(this.instance, last, this.instance.ticksOnEntry);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        super.onClose();
        ModMessages.sendToServer(new CloseDialogueC2SPacket());
    }
}

