/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.custommachineryars.components;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.custommachineryars.Registration;
import es.degrassi.custommachineryars.client.integration.jei.source.Source;
import es.degrassi.custommachineryars.components.ISourceCapExtension;
import es.degrassi.custommachineryars.util.IWandableMachineTile;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.network.syncable.IntegerSyncable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SourceMachineComponent
implements IMachineComponent,
ITickableComponent,
ISerializableComponent,
IComparatorInputComponent,
IDumpComponent,
ISyncableStuff,
ISourceCapExtension {
    private int source;
    private int capacity;
    private final int maxIn;
    private final int maxOut;
    private final IMachineComponentManager manager;

    public SourceMachineComponent(IMachineComponentManager manager) {
        this(manager, 1, 0, 0);
    }

    public SourceMachineComponent(IMachineComponentManager manager, int capacity, int maxIn, int maxOut) {
        this.manager = manager;
        this.capacity = capacity;
        this.maxIn = Math.min(maxIn, capacity);
        this.maxOut = Math.min(maxOut, capacity);
    }

    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.source / (double)this.capacity));
    }

    @Override
    public int getTransferRate() {
        return switch (this.getMode()) {
            default -> throw new MatchException(null, null);
            case ComponentIOMode.INPUT -> this.maxIn;
            case ComponentIOMode.OUTPUT -> this.maxOut;
            case ComponentIOMode.BOTH -> Math.min(this.maxIn, this.maxOut);
            case ComponentIOMode.NONE -> 0;
        };
    }

    public boolean canAcceptSource() {
        return true;
    }

    public boolean canProvideSource() {
        return this.getSource() > 0;
    }

    public boolean canAcceptSource(int source) {
        return this.getSource() + source <= this.getSourceCapacity();
    }

    public boolean canProvideSource(int source) {
        return this.getSource() >= source;
    }

    public int getMaxExtract() {
        return this.getTransferRate();
    }

    public int getMaxReceive() {
        return this.getTransferRate();
    }

    public int getSource() {
        return this.source;
    }

    public int getSourceCapacity() {
        return this.getMaxSource();
    }

    public int getMaxSource() {
        return this.capacity;
    }

    public void setSource(int source) {
        this.source = source;
        this.getManager().markDirty();
    }

    public void setMaxSource(int max) {
        this.capacity = max;
    }

    @Override
    public int addSource(int source) {
        return this.receiveSource(source);
    }

    @Override
    public int removeSource(int source) {
        return this.extractSource(source);
    }

    public int receiveSource(int receive) {
        return this.receiveSource(receive, false);
    }

    public int receiveSource(int maxReceive, boolean simulate) {
        if (this.getMaxInput() <= 0) {
            return 0;
        }
        int sourceReceived = Math.min(this.getCapacity() - this.getSource(), Math.min(this.getMaxInput(), maxReceive));
        return this.receive(sourceReceived, simulate);
    }

    public int receiveSourceRecipe(int maxReceive, boolean simulate) {
        int sourceReceived = Math.min(this.getCapacity() - this.getSource(), maxReceive);
        return this.receive(sourceReceived, simulate);
    }

    private int receive(int sourceReceived, boolean simulate) {
        if (!simulate && sourceReceived > 0) {
            this.setSource(this.getSource() + sourceReceived);
            this.manager.markDirty();
        }
        return sourceReceived;
    }

    public int extractSource(int extract) {
        return this.extractSource(extract, false);
    }

    public int extractSource(int maxExtract, boolean simulate) {
        if (this.getMaxOutput() <= 0) {
            return 0;
        }
        int sourceExtracted = Math.min(this.getSource(), Math.min(this.getMaxOutput(), maxExtract));
        return this.extract(sourceExtracted, simulate);
    }

    public int extractSourceRecipe(int maxExtract, boolean simulate) {
        int sourceExtracted = Math.min(this.getSource(), maxExtract);
        return this.extract(sourceExtracted, simulate);
    }

    private int extract(int sourceExtracted, boolean simulate) {
        if (!simulate && sourceExtracted > 0) {
            this.setSource(this.getSource() - sourceExtracted);
            this.manager.markDirty();
        }
        return sourceExtracted;
    }

    public double getFillPercent() {
        return (double)this.source / (double)this.capacity;
    }

    public boolean isFull() {
        return this.capacity == this.source;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxInput() {
        return this.maxIn;
    }

    public int getMaxOutput() {
        return this.maxOut;
    }

    public void dump(List<String> ids) {
        this.setSource(0);
        this.manager.markDirty();
    }

    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putInt("source", this.source);
    }

    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("source", 3)) {
            this.source = Math.min(nbt.getInt("source"), this.capacity);
        }
    }

    public MachineComponentType<?> getType() {
        return Registration.SOURCE_MACHINE_COMPONENT.get();
    }

    public ComponentIOMode getMode() {
        return ComponentIOMode.BOTH;
    }

    public IMachineComponentManager getManager() {
        return this.manager;
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept((ISyncable<?, ?>)IntegerSyncable.create(() -> this.source, mana -> {
            this.source = mana;
        }));
    }

    private ParticleColor getParticleColor() {
        return ParticleColor.defaultParticleColor();
    }

    public void serverTick() {
        BlockEntity tile2;
        BlockEntity blockEntity;
        IWandableMachineTile wandableMachine = (IWandableMachineTile)this.manager.getTile();
        if (wandableMachine.cma$getFromPos() != null && this.manager.getLevel().isLoaded(wandableMachine.cma$getFromPos())) {
            if (!(this.manager.getLevel().getBlockEntity(wandableMachine.cma$getFromPos()) instanceof AbstractSourceMachine)) {
                blockEntity = this.manager.getLevel().getBlockEntity(wandableMachine.cma$getFromPos());
                if (blockEntity instanceof CustomMachineTile) {
                    CustomMachineTile tile2 = (CustomMachineTile)blockEntity;
                    if (tile2.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).isEmpty()) {
                        wandableMachine.cma$setFromPos(null);
                    } else if (wandableMachine.cma$transferSource((ISourceCapExtension)tile2.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).get(), (ISourceCapExtension)this) > 0) {
                        ParticleUtil.spawnFollowProjectile((Level)this.manager.getLevel(), (BlockPos)wandableMachine.cma$getFromPos(), (BlockPos)this.manager.getTile().getBlockPos(), (ParticleColor)this.getParticleColor());
                    }
                    this.manager.markDirty();
                    return;
                }
                wandableMachine.cma$setFromPos(null);
                this.manager.markDirty();
            } else {
                AbstractSourceMachine fromTile;
                tile2 = this.manager.getLevel().getBlockEntity(wandableMachine.cma$getFromPos());
                if (tile2 instanceof AbstractSourceMachine && wandableMachine.cma$transferSource((ISourceTile)(fromTile = (AbstractSourceMachine)tile2), (ISourceCapExtension)this) > 0) {
                    this.manager.markDirty();
                    ParticleUtil.spawnFollowProjectile((Level)this.manager.getLevel(), (BlockPos)wandableMachine.cma$getFromPos(), (BlockPos)this.manager.getTile().getBlockPos(), (ParticleColor)this.getParticleColor());
                }
            }
        }
        if (wandableMachine.cma$getToPos() != null && this.manager.getLevel().isLoaded(wandableMachine.cma$getToPos())) {
            tile2 = this.manager.getLevel().getBlockEntity(wandableMachine.cma$getToPos());
            if (!(tile2 instanceof AbstractSourceMachine)) {
                blockEntity = this.manager.getLevel().getBlockEntity(wandableMachine.cma$getToPos());
                if (blockEntity instanceof CustomMachineTile) {
                    tile2 = (CustomMachineTile)blockEntity;
                    if (tile2.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).isEmpty()) {
                        wandableMachine.cma$setToPos(null);
                    } else if (wandableMachine.cma$transferSource((ISourceCapExtension)tile2.getComponentManager().getComponent(Registration.SOURCE_MACHINE_COMPONENT.get()).get(), (ISourceCapExtension)this) > 0) {
                        ParticleUtil.spawnFollowProjectile((Level)this.manager.getLevel(), (BlockPos)wandableMachine.cma$getToPos(), (BlockPos)this.manager.getTile().getBlockPos(), (ParticleColor)this.getParticleColor());
                    }
                    this.manager.markDirty();
                    return;
                }
                wandableMachine.cma$setToPos(null);
                this.manager.markDirty();
                return;
            }
            AbstractSourceMachine toTile = (AbstractSourceMachine)tile2;
            if (wandableMachine.cma$transferSource((ISourceCapExtension)this, (ISourceTile)toTile) > 0) {
                ParticleUtil.spawnFollowProjectile((Level)this.manager.getLevel(), (BlockPos)this.manager.getTile().getBlockPos(), (BlockPos)wandableMachine.cma$getToPos(), (ParticleColor)this.getParticleColor());
            }
        }
    }

    public record Template(int capacity, int maxInput, int maxOutput) implements IMachineComponentTemplate<SourceMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("capacity").forGetter(template -> template.capacity), (App)NamedCodec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("maxInput").forGetter(template -> Optional.of(template.maxInput)), (App)NamedCodec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("maxOutput").forGetter(template -> Optional.of(template.maxOutput))).apply((Applicative)templateInstance, (capacity, maxIn, maxOut) -> new Template((int)capacity, maxIn.orElse(capacity), maxOut.orElse(capacity))), (String)"Source machine component");

        public MachineComponentType<SourceMachineComponent> getType() {
            return Registration.SOURCE_MACHINE_COMPONENT.get();
        }

        public String getId() {
            return "";
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return ingredient instanceof Source;
        }

        public SourceMachineComponent build(IMachineComponentManager manager) {
            return new SourceMachineComponent(manager, this.capacity, this.maxInput, this.maxOutput);
        }
    }
}

