/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.properties;

import com.google.common.base.Suppliers;
import dev.satherov.crystalix.client.lang.CSTranslatable;
import dev.satherov.crystalix.common.properties.IProperty;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CSIntegerProperty
implements IProperty<Integer> {
    private final ItemStack stack;
    private final ResourceLocation location;
    private final String translation;
    private final CSTranslatable description;
    private final String key;
    private final Supplier<DataComponentType<Integer>> type;
    private Integer value;

    protected CSIntegerProperty(ItemStack stack, CSTranslatable translation, CSTranslatable description, ResourceLocation location, int defaultValue, Supplier<DataComponentType<Integer>> supplier) {
        this.stack = stack;
        this.location = location;
        this.translation = translation.translation();
        this.description = description;
        this.key = translation.key();
        this.type = Suppliers.memoize(supplier::get);
        this.value = (Integer)stack.getOrDefault(this.type, (Object)defaultValue);
    }

    public static CSIntegerProperty create(ItemStack stack, CSTranslatable translation, CSTranslatable description, ResourceLocation location, int defaultValue, Supplier<DataComponentType<Integer>> supplier) {
        return new CSIntegerProperty(stack, translation, description, location, defaultValue, supplier);
    }

    @Override
    public DataComponentType<Integer> type() {
        return this.type.get();
    }

    @Override
    public Integer next(boolean forward) {
        return this.value + (forward ? 1 : -1) & 0xFFFFFF;
    }

    @Override
    public Integer set(Integer value) {
        this.value = value;
        this.stack.set(this.type, (Object)this.value);
        return this.value;
    }

    @Override
    public MutableComponent name() {
        return Component.translatable((String)this.key);
    }

    @Override
    public MutableComponent display() {
        return Component.literal((String)String.format("#%06X", 0xFFFFFF & this.value).toUpperCase()).withColor(this.value.intValue());
    }

    @Override
    public MutableComponent tooltip() {
        return this.description.text();
    }

    @Override
    @Generated
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    @Generated
    public String translation() {
        return this.translation;
    }

    @Generated
    public CSTranslatable description() {
        return this.description;
    }

    @Override
    @Generated
    public String key() {
        return this.key;
    }

    @Override
    @Generated
    public Integer value() {
        return this.value;
    }
}

