/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.common.block;

import com.mojang.serialization.MapCodec;
import dev.satherov.crystalix.common.block.CrystalixGlassTile;
import dev.satherov.crystalix.common.block.SLBlock;
import dev.satherov.crystalix.common.item.CrystalixWand;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.core.CSRegistry;
import dev.satherov.crystalix.core.annotations.NothingNull;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WaterloggedTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

@NothingNull
public class CrystalixGlass
extends SLBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<WaterloggedTransparentBlock> CODEC = BlockBehaviour.simpleCodec(WaterloggedTransparentBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty WATERLOGGABLE = BooleanProperty.create((String)"waterloggable");
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");
    public static final BooleanProperty SHADELESS = BooleanProperty.create((String)"shadeless");
    public static final BooleanProperty TRANSPARENT = BooleanProperty.create((String)"transparent");
    public static final BooleanProperty REDSTONE = BooleanProperty.create((String)"redstone");
    public static final BooleanProperty REINFORCED = BooleanProperty.create((String)"reinforced");
    public static final EnumProperty<CSProperties.Light> LIGHT = EnumProperty.create((String)"light", CSProperties.Light.class);
    public static final EnumProperty<CSProperties.Ghost> GHOST = EnumProperty.create((String)"ghost", CSProperties.Ghost.class);
    private final CSRegistry.Types type;
    @Nullable
    private final CSRegistry.Colors color;

    public CrystalixGlass(CSRegistry.Types type, @Nullable CSRegistry.Colors color) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS).isRedstoneConductor(CrystalixGlassTile.isRedstoneConductor()));
        this.type = type;
        this.color = color;
    }

    protected MapCodec<? extends WaterloggedTransparentBlock> codec() {
        return CODEC;
    }

    @Override
    protected void registerState(SLBlock.StateBuilder builder) {
        builder.addValue(WATERLOGGED, false);
        builder.addValue(WATERLOGGABLE, false);
        builder.addValue(INVISIBLE, false);
        builder.addValue(SHADELESS, false);
        builder.addValue(REDSTONE, false);
        builder.addValue(TRANSPARENT, true);
        builder.addValue(REINFORCED, false);
        builder.addValue(LIGHT, CSProperties.Light.NONE);
        builder.addValue(GHOST, CSProperties.Ghost.BLOCK_ALL);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        if (player == null) {
            return state;
        }
        FluidState fluidState = level.getFluidState(pos);
        state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(!fluidState.is(Fluids.EMPTY)));
        ItemStack stack = player.getItemInHand(InteractionHand.OFF_HAND);
        if (stack.getItem() instanceof CrystalixWand) {
            return this.fromStack(state, stack);
        }
        return state;
    }

    public Integer getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        Integer n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrystalixGlassTile) {
            CrystalixGlassTile tile = (CrystalixGlassTile)blockEntity;
            n = tile.getColor();
        } else {
            n = 0xFFFFFF;
        }
        return n;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(state);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)WATERLOGGABLE) != false && fluid == Fluids.WATER;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)WATERLOGGABLE)).booleanValue() || ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || fluidState.getType() != Fluids.WATER) {
            return false;
        }
        if (!level.isClientSide()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return true;
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected float getShadeBrightness(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)INVISIBLE) != false ? RenderShape.INVISIBLE : super.getRenderShape(state);
    }

    protected boolean skipRendering(BlockState state, BlockState adjacent, Direction side) {
        return adjacent.is((Block)this) && (Boolean)adjacent.getValue((Property)INVISIBLE) == false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return CrystalixGlassTile.isReinforced(level, pos) && super.canDropFromExplosion(state, level, pos, explosion);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return CrystalixGlassTile.isReinforced((BlockGetter)context.getLevel(), context.getClickedPos()) && super.canBeReplaced(state, context);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!CrystalixGlassTile.isReinforced((BlockGetter)level, pos)) {
            super.onBlockExploded(state, level, pos, explosion);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return !CrystalixGlassTile.isReinforced(getter, pos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        return CrystalixGlassTile.isReinforced(getter, pos) ? Float.MAX_VALUE : super.getExplosionResistance();
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        float progress = super.getDestroyProgress(state, player, getter, pos);
        if (CrystalixGlassTile.isReinforced(getter, pos)) {
            progress *= 0.1f;
        }
        return progress;
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getValue(LIGHT) != CSProperties.Light.DARK;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level instanceof ServerLevel) {
            return;
        }
        if (state.getValue(LIGHT) != CSProperties.Light.FAKE_LIGHT) {
            return;
        }
        level.getLightEngine().checkBlock(pos);
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getValue(LIGHT) == CSProperties.Light.DARK ? level.getMaxLightLevel() : 0;
    }

    public int getLightEmission(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        CSProperties.Light light = (CSProperties.Light)((Object)state.getValue(LIGHT));
        if (light == CSProperties.Light.FAKE_LIGHT) {
            return FMLLoader.getDist() == Dist.CLIENT ? 15 : 0;
        }
        if (light == CSProperties.Light.LIGHT) {
            return 15;
        }
        return 0;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context) != CollisionContext.empty() && ((CSProperties.Ghost)((Object)state.getValue(GHOST))).canCollide(entityCollisionContext)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        if (pathComputationType == PathComputationType.LAND) {
            return switch ((CSProperties.Ghost)((Object)state.getValue(GHOST))) {
                case CSProperties.Ghost.ALLOW_ALL, CSProperties.Ghost.ALLOW_ANIMAL, CSProperties.Ghost.ALLOW_MONSTER -> true;
                default -> false;
            };
        }
        return false;
    }

    protected boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)REDSTONE);
    }

    protected int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)REDSTONE) != false ? 15 : 0;
    }

    public BlockState fromStack(BlockState state, ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof CrystalixWand)) {
            return state;
        }
        if (!(state.getBlock() instanceof CrystalixGlass)) {
            return state;
        }
        state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)INVISIBLE, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.INVISIBLE)))).setValue((Property)SHADELESS, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.SHADELESS)))).setValue((Property)WATERLOGGABLE, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.WATERLOGGABLE)))).setValue((Property)TRANSPARENT, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.TRANSPARENT)))).setValue((Property)REDSTONE, (Comparable)Objects.requireNonNull((Boolean)stack.get(CSRegistry.REDSTONE)))).setValue(LIGHT, (Comparable)((Object)Objects.requireNonNull((CSProperties.Light)stack.get(CSRegistry.LIGHT))))).setValue(GHOST, (Comparable)((Object)Objects.requireNonNull((CSProperties.Ghost)stack.get(CSRegistry.GHOST))));
        return state;
    }

    public boolean setEntityProperties(BlockGetter getter, BlockPos pos, BlockState state, ItemStack stack) {
        CrystalixGlassTile tile;
        block5: {
            block4: {
                BlockEntity be = getter.getBlockEntity(pos);
                if (!(be instanceof CrystalixGlassTile)) break block4;
                tile = (CrystalixGlassTile)be;
                if (getter instanceof Level) break block5;
            }
            return false;
        }
        Level level = (Level)getter;
        if (!((Boolean)stack.getOrDefault(CSRegistry.APPLY_COLORLESS, (Object)false)).booleanValue()) {
            tile.setColor(state, (Integer)stack.getOrDefault(CSRegistry.COLOR, (Object)0xFFFFFF));
        }
        tile.setReinforced((Boolean)stack.getOrDefault(CSRegistry.REINFORCED, (Object)false));
        tile.setConductor((Boolean)stack.getOrDefault(CSRegistry.CONDUCTOR, (Object)false));
        level.setBlockAndUpdate(pos, state);
        level.updateNeighborsAt(pos, (Block)this);
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrystalixGlassTile(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        if (!(placer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)placer;
        ItemStack wand = CrystalixWand.find((Player)player);
        this.setEntityProperties((BlockGetter)world, pos, state, wand);
        super.setPlacedBy((Level)level, pos, state, placer, stack);
    }

    @Generated
    public CSRegistry.Types type() {
        return this.type;
    }

    @Nullable
    @Generated
    public CSRegistry.Colors color() {
        return this.color;
    }
}

