/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix;

import dev.satherov.crystalix.common.block.CrystalixGlass;
import dev.satherov.crystalix.common.block.CrystalixGlassTile;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.config.ConfigLoader;
import dev.satherov.crystalix.core.CSRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="crystalix")
@EventBusSubscriber(modid="crystalix")
public class Crystalix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Crystalix.class);
    public static final String MOD_ID = "crystalix";
    private static Crystalix instance;
    private final ConfigLoader loader = ConfigLoader.create();

    public Crystalix(IEventBus bus, FMLModContainer container) {
        if (instance != null) {
            throw new IllegalStateException("Already initialized");
        }
        instance = this;
        this.loader.discover(container);
        CSRegistry.register(bus);
    }

    @SubscribeEvent
    private static void opInDev(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer entity = (ServerPlayer)player;
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            ServerLevel level = entity.serverLevel();
            MinecraftServer server = level.getServer();
            server.getPlayerList().op(entity.getGameProfile());
        }
    }

    @SubscribeEvent
    private static void onConfigLoad(ModConfigEvent.Loading event) {
        Crystalix.getInstance().getLoader().update(event.getConfig().getSpec());
    }

    @SubscribeEvent
    private static void onConfigReload(ModConfigEvent.Reloading event) {
        Crystalix.getInstance().getLoader().update(event.getConfig().getSpec());
    }

    @SubscribeEvent
    private static void registerAliases(FMLLoadCompleteEvent event) {
        CSRegistry.OLD_ENTRIES.cellSet().forEach(cell -> BuiltInRegistries.ITEM.addAlias(((DeferredHolder)cell.getValue()).getId(), Crystalix.rl(((CSRegistry.Types)((Object)((Object)cell.getRowKey()))).format())));
    }

    @SubscribeEvent
    private static void onChunkLoad(ChunkEvent.Load event) {
        if (event.isNewChunk()) {
            return;
        }
        ChunkAccess chunk = event.getChunk();
        if (((Boolean)chunk.getData(CSRegistry.MIGRATED)).booleanValue()) {
            return;
        }
        Level world = event.getChunk().getLevel();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        chunk.setData(CSRegistry.MIGRATED, (Object)Boolean.TRUE);
        List<LevelChunkSection> sections = Arrays.stream(chunk.getSections()).filter(section -> !section.hasOnlyAir()).filter(section -> section.maybeHas(state -> state.getBlock() instanceof CrystalixGlass)).toList();
        if (sections.isEmpty()) {
            return;
        }
        HashMap map = new HashMap();
        chunk.findBlocks(state -> {
            CrystalixGlass glass;
            Block patt0$temp = state.getBlock();
            return patt0$temp instanceof CrystalixGlass && (glass = (CrystalixGlass)patt0$temp).color() != null;
        }, (pos, state) -> map.put(pos.immutable(), state));
        ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER)).tell((Runnable)new TickTask(1, () -> map.forEach((pos, state) -> {
            CrystalixGlass glass = (CrystalixGlass)state.getBlock();
            int color = Objects.requireNonNull(glass.color()).color();
            BlockState migrated = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((CrystalixGlass)((Object)((Object)((Object)CSRegistry.ENTRIES.get((Object)glass.type()).get())))).defaultBlockState().setValue((Property)CrystalixGlass.INVISIBLE, (Comparable)((Boolean)state.getValue((Property)CrystalixGlass.INVISIBLE)))).setValue((Property)CrystalixGlass.SHADELESS, (Comparable)((Boolean)state.getValue((Property)CrystalixGlass.SHADELESS)))).setValue((Property)CrystalixGlass.WATERLOGGABLE, (Comparable)((Boolean)state.getValue((Property)CrystalixGlass.WATERLOGGABLE)))).setValue((Property)CrystalixGlass.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)CrystalixGlass.WATERLOGGED)))).setValue((Property)CrystalixGlass.TRANSPARENT, (Comparable)Boolean.valueOf(color < 0))).setValue(CrystalixGlass.LIGHT, (Comparable)((Object)((CSProperties.Light)((Object)state.getValue(CrystalixGlass.LIGHT)))))).setValue(CrystalixGlass.GHOST, (Comparable)((Object)((CSProperties.Ghost)((Object)state.getValue(CrystalixGlass.GHOST)))));
            chunk.setBlockState(pos, migrated, false);
            CrystalixGlassTile tile = new CrystalixGlassTile((BlockPos)pos, Objects.requireNonNull(migrated));
            tile.setColor((BlockState)state, color);
            tile.setReinforced((Boolean)state.getValue((Property)CrystalixGlass.REINFORCED));
            chunk.setBlockEntity((BlockEntity)tile);
            level.updateNeighborsAt(pos, migrated.getBlock());
        })));
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @Generated
    public static Crystalix getInstance() {
        return instance;
    }

    @Generated
    public ConfigLoader getLoader() {
        return this.loader;
    }
}

