/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.overstressclutch;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.content.overstressclutch.OverstressClutchBlock;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;

public class OverstressClutchBlockEntity
extends SplitShaftBlockEntity {
    public int delay;
    public ScrollValueBehaviour maxDelay;

    public OverstressClutchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        AdvancementBehaviour.registerAwardables((SmartBlockEntity)this, behaviours, CCAdvancements.OVERSTRESS_CLUTCH);
        this.maxDelay = new TimeDelayScrollValueBehaviour((Component)Component.translatable((String)"create_connected.overstress_clutch.uncouple_delay"), (SmartBlockEntity)this, (ValueBoxTransform)new CenteredSideValueBoxTransform((state, d) -> {
            Direction.Axis axis = d.getAxis();
            Direction.Axis bearingAxis = (Direction.Axis)state.getValue((Property)OverstressClutchBlock.AXIS);
            return bearingAxis != axis;
        })).between(1, 72000);
        this.maxDelay.withFormatter(this::format);
        this.maxDelay.withCallback(this::onMaxDelayChanged);
        this.maxDelay.setValue(1);
        behaviours.add((BlockEntityBehaviour)this.maxDelay);
    }

    private void onMaxDelayChanged(int newMax) {
        this.delay = Mth.clamp((int)this.delay, (int)0, (int)newMax);
        this.sendData();
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    public boolean isIdle() {
        return this.delay == 0;
    }

    public void initialize() {
        this.onKineticUpdate();
        super.initialize();
    }

    public void onKineticUpdate() {
        if (this.getBlockState().getValue(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED && ((Boolean)this.getBlockState().getValue((Property)OverstressClutchBlock.POWERED)).booleanValue()) {
            this.resetClutch();
            return;
        }
        if (IRotate.StressImpact.isEnabled() && !((Boolean)this.getBlockState().getValue((Property)OverstressClutchBlock.POWERED)).booleanValue() && this.isOverStressed() && this.getBlockState().getValue(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.COUPLED && this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.UNCOUPLING)), 18);
            this.delay = this.maxDelay.getValue() - 1;
            this.sendData();
            return;
        }
        if (!this.isOverStressed() && this.getBlockState().getValue(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLING && this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.COUPLED)), 18);
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.onKineticUpdate();
    }

    public float getRotationSpeedModifier(Direction face) {
        if (this.hasSource() && face != this.getSourceFacing() && this.getBlockState().getValue(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED) {
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToTooltip(tooltip, isPlayerSneaking);
        if (this.getBlockState().getValue(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED) {
            ConnectedLang.translate("gui.overstress_clutch.uncoupled", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            MutableComponent hint = ConnectedLang.translateDirect("gui.overstress_clutch.uncoupled_explanation", new Object[0]);
            List cutString = TooltipHelper.cutTextComponent((Component)hint, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE);
            for (Component component : cutString) {
                ConnectedLang.builder().add(component.copy()).forGoggles(tooltip);
            }
            added = true;
        }
        return added;
    }

    public void resetClutch() {
        if (this.getBlockState().getValue(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED && !this.isOverStressed()) {
            assert (this.level != null);
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.COUPLED)), 3);
            RotationPropagator.handleRemoved((Level)this.level, (BlockPos)this.getBlockPos(), (KineticBlockEntity)this);
            RotationPropagator.handleAdded((Level)this.level, (BlockPos)this.getBlockPos(), (KineticBlockEntity)this);
        }
    }

    public void tick() {
        super.tick();
        if (this.getBlockState().getValue(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLING && this.level != null && !this.level.isClientSide) {
            this.level.scheduleTick(this.getBlockPos(), (Block)CCBlocks.OVERSTRESS_CLUTCH.get(), 0, TickPriority.EXTREMELY_HIGH);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.delay = compound.getInt("Delay");
        super.read(compound, registries, clientPacket);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("Delay", this.delay);
        super.write(compound, registries, clientPacket);
    }

    public static class TimeDelayScrollValueBehaviour
    extends ScrollValueBehaviour {
        public TimeDelayScrollValueBehaviour(Component label, SmartBlockEntity be, ValueBoxTransform slot) {
            super(label, be, slot);
        }

        public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
            return new ValueSettingsBoard(this.label, 60, 10, CreateLang.translatedOptions((String)"generic.unit", (String[])new String[]{"ticks", "seconds", "minutes"}), new ValueSettingsFormatter(this::formatSettings));
        }

        public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
            BlockState blockState = this.blockEntity.getBlockState();
            Block block = blockState.getBlock();
            if (block instanceof BrassDiodeBlock) {
                BrassDiodeBlock bdb = (BrassDiodeBlock)block;
                bdb.toggle(this.getWorld(), this.getPos(), blockState, player, hand);
            }
        }

        public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
            int multiplier;
            int value = valueSetting.value();
            switch (valueSetting.row()) {
                case 0: {
                    int n = 1;
                    break;
                }
                case 1: {
                    int n = 20;
                    break;
                }
                default: {
                    int n = multiplier = 1200;
                }
            }
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            this.setValue(Math.max(1, Math.max(1, value) * multiplier));
        }

        public ValueSettingsBehaviour.ValueSettings getValueSettings() {
            int row = 0;
            int value = this.value;
            if (value > 1200) {
                value /= 1200;
                row = 2;
            } else if (value > 60) {
                value /= 20;
                row = 1;
            }
            return new ValueSettingsBehaviour.ValueSettings(row, value);
        }

        public MutableComponent formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
            int value = Math.max(1, settings.value());
            return Component.literal((String)(switch (settings.row()) {
                case 0 -> value + "t";
                case 1 -> "0:" + (value < 10 ? "0" : "") + value;
                default -> value + ":00";
            }));
        }

        public String getClipboardKey() {
            return "Timings";
        }
    }
}

