/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.crankwheel;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.crankwheel.CrankWheelBlockEntity;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrankWheelBlock
extends HandCrankBlock
implements ICogWheel {
    public static EnumProperty<Direction.Axis> AXIS = CogWheelBlock.AXIS;
    public final boolean largeCog;

    public CrankWheelBlock(BlockBehaviour.Properties properties, boolean largeCog) {
        super(properties);
        this.largeCog = largeCog;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
        super.createBlockStateDefinition(builder);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.largeCog ? CCShapes.LARGE_CRANK_WHEEL.get((Direction)state.getValue((Property)FACING)) : CCShapes.CRANK_WHEEL.get((Direction)state.getValue((Property)FACING));
    }

    public BlockEntityType<? extends CrankWheelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.CRANK_WHEEL.get();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        BlockState defaultBlockState = this.withWater(this.defaultBlockState(), context);
        if (preferred == null || context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            return (BlockState)((BlockState)defaultBlockState.setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue(AXIS, (Comparable)context.getClickedFace().getAxis());
        }
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)preferred.getAxis(), (Direction.AxisDirection)context.getNearestLookingDirection().getOpposite().getAxisDirection());
        return (BlockState)((BlockState)defaultBlockState.setValue((Property)FACING, (Comparable)facing)).setValue(AXIS, (Comparable)facing.getAxis());
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction preferredSide = null;
        for (Direction side : Iterate.directions) {
            ICogWheel cog;
            Direction.Axis rotationAxis;
            BlockState blockState = context.getLevel().getBlockState(context.getClickedPos().relative(side));
            Block block = blockState.getBlock();
            if (!(block instanceof ICogWheel) || (rotationAxis = (cog = (ICogWheel)block).getRotationAxis(blockState)) == side.getAxis()) continue;
            if (preferredSide != null && preferredSide.getAxis() != rotationAxis) {
                preferredSide = null;
                break;
            }
            preferredSide = Direction.fromAxisAndDirection((Direction.Axis)rotationAxis, (Direction.AxisDirection)side.getAxisDirection());
        }
        return preferredSide;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)worldIn, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue(AXIS)));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        BlockState newState = super.rotate(state, level, pos, direction);
        return (BlockState)newState.setValue(AXIS, (Comparable)((Direction.Axis)newState.getValue(AXIS)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        BlockState newState = super.mirror(state, mirrorIn);
        return (BlockState)newState.setValue(AXIS, (Comparable)((Direction.Axis)newState.getValue(AXIS)));
    }

    public boolean isLargeCog() {
        return this.largeCog;
    }

    public boolean isSmallCog() {
        return !this.largeCog;
    }

    public static class Large
    extends CrankWheelBlock {
        public Large(BlockBehaviour.Properties properties) {
            super(properties, true);
        }
    }

    public static class Small
    extends CrankWheelBlock {
        public Small(BlockBehaviour.Properties properties) {
            super(properties, false);
        }
    }
}

