/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.wall;

import com.hlysine.create_connected.content.copycat.ICopycatWithWrappedBlock;
import com.hlysine.create_connected.content.copycat.WaterloggedCopycatWrappedBlock;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import java.util.Arrays;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopycatWallBlock
extends WaterloggedCopycatWrappedBlock {
    public static WallBlock wall;

    public CopycatWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WallBlock.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)WallBlock.NORTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)WallSide.NONE)).setValue((Property)WallBlock.EAST_WALL, (Comparable)WallSide.NONE)).setValue((Property)WallBlock.WEST_WALL, (Comparable)WallSide.NONE));
    }

    @Override
    public Block getWrappedBlock() {
        return wall;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{WallBlock.UP, WallBlock.NORTH_WALL, WallBlock.SOUTH_WALL, WallBlock.EAST_WALL, WallBlock.WEST_WALL}));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        BlockState state = wall.getStateForPlacement(pContext);
        if (state == null) {
            return super.getStateForPlacement(pContext);
        }
        return ICopycatWithWrappedBlock.copyState(state, super.getStateForPlacement(pContext), false);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return ICopycatWithWrappedBlock.wrappedState((Block)wall, pState).getShape(pLevel, pPos, pContext);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return ICopycatWithWrappedBlock.wrappedState((Block)wall, pState).getCollisionShape(pLevel, pPos, pContext);
    }

    protected boolean isPathfindable(@NotNull BlockState pState, @NotNull PathComputationType pPathComputationType) {
        return ICopycatWithWrappedBlock.wrappedState((Block)wall, pState).isPathfindable(pPathComputationType);
    }

    @Override
    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        return CopycatWallBlock.migrateOnUpdate(pLevel.isClientSide(), ICopycatWithWrappedBlock.unwrapForOperation((Block)wall, pState, state -> state.updateShape(pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos)));
    }

    public boolean propagatesSkylightDown(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos) {
        return ICopycatWithWrappedBlock.wrappedState((Block)wall, pState).propagatesSkylightDown(pLevel, pPos);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState pState, @NotNull Rotation pRotation) {
        return ICopycatWithWrappedBlock.unwrapForOperation((Block)wall, pState, state -> state.rotate(pRotation));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return ICopycatWithWrappedBlock.unwrapForOperation((Block)wall, pState, state -> state.mirror(pMirror));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, @Nullable BlockPos fromPos, @Nullable BlockPos toPos) {
        if (fromPos == null || toPos == null) {
            return true;
        }
        BlockState toState = reader.getBlockState(toPos);
        if (!toState.is((Block)this) || !state.is((Block)this)) {
            return true;
        }
        boolean isCross = true;
        for (Direction direction : Iterate.horizontalDirections) {
            if (toState.getValue(CopycatWallBlock.byDirection(direction)) != WallSide.NONE) continue;
            isCross = false;
            break;
        }
        return isCross;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.getBlockState(toPos);
        if (!toState.is((Block)this)) {
            return false;
        }
        long sideCount = Arrays.stream(Iterate.horizontalDirections).filter(s -> state.getValue(CopycatWallBlock.byDirection(s)) != WallSide.NONE).count();
        if (sideCount > 2L) {
            return false;
        }
        if (sideCount == 2L && (state.getValue((Property)WallBlock.NORTH_WALL) != state.getValue((Property)WallBlock.SOUTH_WALL) || state.getValue((Property)WallBlock.EAST_WALL) != state.getValue((Property)WallBlock.WEST_WALL))) {
            return false;
        }
        BlockPos diff = toPos.subtract((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.ZERO)) {
            return true;
        }
        Direction face = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
        if (face == null) {
            if (diff.distManhattan(Vec3i.ZERO) > 2) {
                return false;
            }
            if (diff.getY() == 0) {
                return false;
            }
            Direction horizontalDiff = Direction.fromAxisAndDirection((Direction.Axis)(diff.getX() == 0 ? Direction.Axis.Z : Direction.Axis.X), (Direction.AxisDirection)(diff.getX() + diff.getZ() > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
            if (diff.getY() > 0) {
                if (state.getValue(CopycatWallBlock.byDirection(horizontalDiff)) != WallSide.TALL) {
                    return false;
                }
                if (toState.getValue(CopycatWallBlock.byDirection(horizontalDiff.getOpposite())) == WallSide.NONE) {
                    return false;
                }
            } else {
                if (state.getValue(CopycatWallBlock.byDirection(horizontalDiff)) == WallSide.NONE) {
                    return false;
                }
                if (toState.getValue(CopycatWallBlock.byDirection(horizontalDiff.getOpposite())) != WallSide.TALL) {
                    return false;
                }
            }
            return true;
        }
        if (face == Direction.DOWN || face == Direction.UP) {
            return this.canConnectVertically(state) && this.canConnectVertically(toState);
        }
        if (((Boolean)state.getValue((Property)WallBlock.UP)).booleanValue()) {
            return false;
        }
        return state.getValue(CopycatWallBlock.byDirection(face)) != WallSide.NONE;
    }

    private boolean canConnectVertically(BlockState state) {
        if (!((Boolean)state.getValue((Property)WallBlock.UP)).booleanValue()) {
            return false;
        }
        for (Direction direction : Iterate.horizontalDirections) {
            WallSide side = (WallSide)state.getValue(CopycatWallBlock.byDirection(direction));
            if (side == WallSide.NONE) continue;
            return false;
        }
        return true;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        if (face.getAxis().isHorizontal()) {
            WallSide side = (WallSide)state.getValue(CopycatWallBlock.byDirection(face));
            return side != WallSide.NONE && (Boolean)state.getValue((Property)WallBlock.UP) == false && side == state.getValue(CopycatWallBlock.byDirection(face.getOpposite())) && state.getValue(CopycatWallBlock.byDirection(face.getClockWise())) == WallSide.NONE && state.getValue(CopycatWallBlock.byDirection(face.getCounterClockWise())) == WallSide.NONE;
        }
        return false;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if ((neighborState.getBlock() instanceof WallBlock || neighborState.getBlock() instanceof CopycatWallBlock) && CopycatWallBlock.getMaterial(level, pos).skipRendering(CopycatWallBlock.getMaterial(level, pos.relative(dir)), dir.getOpposite())) {
            if (dir.getAxis().isHorizontal()) {
                WallSide side = (WallSide)state.getValue(CopycatWallBlock.byDirection(dir));
                return side != WallSide.NONE && side == neighborState.getValue(CopycatWallBlock.byDirection(dir.getOpposite()));
            }
            if (((Boolean)neighborState.getValue((Property)WallBlock.UP)).booleanValue() && !((Boolean)state.getValue((Property)WallBlock.UP)).booleanValue()) {
                return false;
            }
            return Arrays.stream(Iterate.horizontalDirections).allMatch(s -> {
                WallSide neighbor = (WallSide)neighborState.getValue(CopycatWallBlock.byDirection(s));
                WallSide self = (WallSide)state.getValue(CopycatWallBlock.byDirection(s));
                if (dir == Direction.UP && self == WallSide.LOW) {
                    return false;
                }
                if (dir == Direction.DOWN && neighbor == WallSide.LOW) {
                    return false;
                }
                return self == neighbor;
            });
        }
        return false;
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockState state = CopycatBlock.getMaterial((BlockGetter)reader, (BlockPos)targetPos);
        if (state.is(Blocks.AIR)) {
            return reader.getBlockState(targetPos);
        }
        return state;
    }

    public static EnumProperty<WallSide> byDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> WallBlock.NORTH_WALL;
            case Direction.SOUTH -> WallBlock.SOUTH_WALL;
            case Direction.WEST -> WallBlock.WEST_WALL;
            case Direction.EAST -> WallBlock.EAST_WALL;
            default -> throw new IllegalArgumentException("Vertical directions not supported");
        };
    }
}

