/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createshimmer.mixin;

import com.adonis.createshimmer.common.registry.CSBlocks;
import com.adonis.createshimmer.common.registry.CSFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.util.TriState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SugarCaneBlock.class})
public abstract class SugarCaneBlockMixin
extends Block {
    public SugarCaneBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"canSurvive"}, at={@At(value="HEAD")}, cancellable=true)
    protected void injectCanSurvive(BlockState state, LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        boolean isSupportedSoil;
        BlockState blockStateBelow = level.getBlockState(pos.below());
        if (blockStateBelow.is((Block)this)) {
            cir.setReturnValue((Object)true);
            return;
        }
        TriState soilDecision = blockStateBelow.canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, state);
        if (!soilDecision.isDefault()) {
            cir.setReturnValue((Object)soilDecision.isTrue());
            return;
        }
        boolean bl = isSupportedSoil = blockStateBelow.is(BlockTags.DIRT) || blockStateBelow.is(BlockTags.SAND) || blockStateBelow.is((Block)CSBlocks.MAGIC_SOIL.get());
        if (isSupportedSoil) {
            BlockPos blockPosBelow = pos.below();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState adjacentState = level.getBlockState(blockPosBelow.relative(direction));
                FluidState fluidState = level.getFluidState(blockPosBelow.relative(direction));
                if (state.canBeHydrated((BlockGetter)level, pos, fluidState, blockPosBelow.relative(direction))) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                if (adjacentState.is(Blocks.FROSTED_ICE)) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                if (!this.isShimmerFluid(fluidState)) continue;
                cir.setReturnValue((Object)true);
                return;
            }
        }
        cir.setReturnValue((Object)false);
    }

    private boolean isShimmerFluid(FluidState fluidState) {
        if (fluidState.isEmpty()) {
            return false;
        }
        return fluidState.getType() == CSFluids.SHIMMER.get() || fluidState.getType() == CSFluids.SHIMMER.getSource();
    }
}

