/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.PlayerCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TeleportCommand
implements Command<CommandSourceStack> {
    private static final TeleportCommand cmd = new TeleportCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"tp").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes((Command)cmd)).then(Commands.argument((String)"dim", (ArgumentType)DimensionArgument.dimension()).executes((Command)cmd)))).then(Commands.argument((String)"otherPlayer", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).executes((Command)cmd)));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        ServerLevel playerWorld = ((CommandSourceStack)context.getSource()).getLevel();
        ServerLevel destWorld = null;
        String otherPlayerName = "";
        String playerName = "";
        BlockPos pos = null;
        try {
            destWorld = DimensionArgument.getDimension(context, (String)"dim");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            otherPlayerName = StringArgumentType.getString(context, (String)"otherPlayer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (destWorld == null) {
            destWorld = playerWorld;
        }
        try {
            playerName = StringArgumentType.getString(context, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (playerName == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtils.CreateTextComponent("player to teleport not specified"));
            return 0;
        }
        ServerPlayer otherPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(otherPlayerName);
        if (pos == null && !otherPlayerName.isEmpty()) {
            if (otherPlayer != null) {
                pos = otherPlayer.getOnPos();
            } else {
                AtomicReference offlinePlayerPos = new AtomicReference();
                if (!WorldUtils.applyToPlayer(otherPlayerName, ((CommandSourceStack)context.getSource()).getServer(), fakePlayer -> offlinePlayerPos.set(fakePlayer.getOnPos()))) {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtils.CreateTextComponent("Unable to load target players data"));
                    return 0;
                }
                pos = (BlockPos)offlinePlayerPos.get();
            }
        }
        if ((player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(playerName)) != null) {
            WorldUtils.teleportPlayer((Player)player, (Level)playerWorld, (Level)destWorld, pos);
        } else {
            ServerLevel finalDestWorld = destWorld;
            BlockPos finalPos = pos;
            if (!WorldUtils.applyToPlayer(playerName, ((CommandSourceStack)context.getSource()).getServer(), fakePlayer -> {
                fakePlayer.setPos((double)finalPos.getX(), (double)finalPos.getY(), (double)finalPos.getZ());
                fakePlayer.setLevel((Level)finalDestWorld);
            })) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)CommandUtils.CreateTextComponent("Unable to read source player data"));
                return 0;
            }
        }
        String finalPlayerName = playerName;
        BlockPos finalPos1 = pos;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Teleported " + finalPlayerName + " to " + finalPos1.toString()), true);
        return 1;
    }
}

