/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import java.util.HashSet;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.network.message.FavoriteListMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ToggleFavoriteMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ToggleFavoriteMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"toggle_favorite"));
    private final ResourceLocation itemId;
    private final boolean favorite;

    public ToggleFavoriteMessage(ResourceLocation itemId, boolean favorite) {
        this.itemId = itemId;
        this.favorite = favorite;
    }

    public static void encode(FriendlyByteBuf buf, ToggleFavoriteMessage message) {
        buf.writeResourceLocation(message.itemId);
        buf.writeBoolean(message.favorite);
    }

    public static ToggleFavoriteMessage decode(FriendlyByteBuf buf) {
        ResourceLocation itemId = buf.readResourceLocation();
        boolean favorite = buf.readBoolean();
        return new ToggleFavoriteMessage(itemId, favorite);
    }

    public static void handle(ServerPlayer player, ToggleFavoriteMessage message) {
        CompoundTag data = Balm.getHooks().getPersistentData((Player)player);
        CompoundTag cfbData = data.getCompound("CookingForBlockheads");
        CompoundTag favoriteItems = cfbData.getCompound("FavoriteItemIds");
        if (message.favorite) {
            favoriteItems.putBoolean(message.itemId.toString(), true);
        } else {
            favoriteItems.remove(message.itemId.toString());
        }
        cfbData.put("FavoriteItemIds", (Tag)favoriteItems);
        data.put("CookingForBlockheads", (Tag)cfbData);
        HashSet<ResourceLocation> favoriteItemIds = new HashSet<ResourceLocation>();
        for (String favoriteItemId : favoriteItems.getAllKeys()) {
            favoriteItemIds.add(ResourceLocation.parse((String)favoriteItemId));
        }
        Balm.getNetworking().sendTo((Player)player, (CustomPacketPayload)new FavoriteListMessage(favoriteItemIds));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

