/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class RequestSelectionRecipesMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RequestSelectionRecipesMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"request_selection_recipes"));
    private final ItemStack outputItem;
    private final NonNullList<ItemStack> lockedInputs;

    public RequestSelectionRecipesMessage(ItemStack outputItem, NonNullList<ItemStack> lockedInputs) {
        this.outputItem = outputItem;
        this.lockedInputs = lockedInputs;
    }

    public static RequestSelectionRecipesMessage decode(RegistryFriendlyByteBuf buf) {
        ItemStack outputItem = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        int lockedInputsCount = buf.readByte();
        NonNullList lockedInputs = NonNullList.createWithCapacity((int)lockedInputsCount);
        for (int i = 0; i < lockedInputsCount; ++i) {
            lockedInputs.add((Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf)));
        }
        return new RequestSelectionRecipesMessage(outputItem, (NonNullList<ItemStack>)lockedInputs);
    }

    public static void encode(RegistryFriendlyByteBuf buf, RequestSelectionRecipesMessage message) {
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)message.outputItem);
        buf.writeByte(message.lockedInputs.size());
        for (ItemStack itemstack : message.lockedInputs) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)itemstack);
        }
    }

    public static void handle(ServerPlayer player, RequestSelectionRecipesMessage message) {
        AbstractContainerMenu container = player.containerMenu;
        if (container instanceof KitchenMenu) {
            KitchenMenu kitchenMenu = (KitchenMenu)container;
            kitchenMenu.handleRequestSelectionRecipes(message.outputItem, message.lockedInputs);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

