/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.dimension;

import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.gamerule.CMGameRules;
import dev.compactmods.machines.util.PlayerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class VoidAirBlock
extends AirBlock {
    public VoidAirBlock() {
        super(BlockBehaviour.Properties.of().isValidSpawn((state, level, pos, entity) -> false).strength(-1.0f, 3600000.0f).noTerrainParticles().noLootTable().forceSolidOn());
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return false;
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pLevel.isClientSide) {
            return;
        }
        if (!CompactDimension.isLevelCompact((Level)pLevel)) {
            return;
        }
        if (pEntity instanceof ServerPlayer) {
            boolean allowedOutOfBounds;
            ServerPlayer player = (ServerPlayer)pEntity;
            GameRules rules = pLevel.getGameRules();
            if (rules.getBoolean(CMGameRules.DAMAGE_OOB_PLAYERS)) {
                VoidAirBlock.tryDamagingAdventurousPlayer(pLevel, player);
            }
            switch (player.gameMode.getGameModeForPlayer()) {
                default: {
                    throw new MatchException(null, null);
                }
                case ADVENTURE: 
                case SURVIVAL: {
                    boolean bl = rules.getBoolean(CMGameRules.ALLOW_SURVIVAL_OUT_OF_BOUNDS);
                    break;
                }
                case CREATIVE: {
                    boolean bl = rules.getBoolean(CMGameRules.ALLOW_CREATIVE_OUT_OF_BOUNDS);
                    break;
                }
                case SPECTATOR: {
                    boolean bl = allowedOutOfBounds = rules.getBoolean(CMGameRules.ALLOW_SPECTATORS_OUT_OF_BOUNDS);
                }
            }
            if (!allowedOutOfBounds) {
                PlayerUtil.teleportPlayerToRespawnOrOverworld(player.server, player);
            }
        }
    }

    private static void tryDamagingAdventurousPlayer(Level pLevel, ServerPlayer player) {
        if (player.isCreative() || player.isSpectator()) {
            return;
        }
        if (!player.hasEffect(MobEffects.CONFUSION)) {
            player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100));
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100));
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100));
        }
        if (player.getHealth() > 1.0f) {
            player.hurt(pLevel.damageSources().fellOutOfWorld(), player.getHealth() - 1.0f);
        }
    }
}

