/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.neoforge.render;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import terrails.colorfulhearts.render.HeartRenderer;

public class RenderEventHandler {
    public static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final Minecraft client = Minecraft.getInstance();
    private long lastHealthTime;
    private long healthBlinkTime;
    private int displayHealth;
    private int lastHealth;

    public void renderHearts(RenderGuiLayerEvent.Pre event) {
        boolean highlight;
        Entity entity;
        if (event.isCanceled() || this.client.options.hideGui || !event.getName().equals((Object)VanillaGuiLayers.PLAYER_HEALTH) || !Objects.requireNonNull(this.client.gameMode).canHurtPlayer() || !((entity = this.client.getCameraEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.client.getProfiler().push("health");
        int absorption = Mth.ceil((float)player.getAbsorptionAmount());
        int health = Mth.ceil((float)player.getHealth());
        long tickCount = this.client.gui.getGuiTicks();
        boolean bl = highlight = this.healthBlinkTime > tickCount && (this.healthBlinkTime - tickCount) / 3L % 2L == 1L;
        if (health < this.lastHealth && player.invulnerableTime > 0) {
            this.lastHealthTime = Util.getMillis();
            this.healthBlinkTime = tickCount + 20L;
        } else if (health > this.lastHealth && player.invulnerableTime > 0) {
            this.lastHealthTime = Util.getMillis();
            this.healthBlinkTime = tickCount + 10L;
        }
        if (Util.getMillis() - this.lastHealthTime > 1000L) {
            this.displayHealth = health;
            this.lastHealthTime = Util.getMillis();
        }
        this.lastHealth = health;
        int maxHealth = Mth.ceil((float)Math.max((float)player.getAttributeValue(Attributes.MAX_HEALTH), (float)Math.max(this.displayHealth, health)));
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        int left = width / 2 - 91;
        int top = height - this.client.gui.leftHeight;
        boolean hasAbsorptionRow = absorption + Math.min(20, maxHealth == 19 ? 20 : maxHealth) > 20;
        int offset = 10 + (hasAbsorptionRow ? 10 : 0);
        this.client.gui.leftHeight += offset;
        HeartRenderer.INSTANCE.renderPlayerHearts(guiGraphics, player, left, top, maxHealth, health, this.displayHealth, absorption, highlight);
        this.client.getProfiler().pop();
        event.setCanceled(true);
    }
}

