/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import terrails.colorfulhearts.config.screen.ColorSelectionScreen;
import terrails.colorfulhearts.config.screen.widgets.LabelLine;

public class ConfigurationScreen
extends Screen {
    private final Screen lastScreen;

    public ConfigurationScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"colorfulhearts.screen.configuration.title"));
        this.lastScreen = lastScreen;
    }

    protected void init() {
        assert (this.minecraft != null);
        Font font = this.minecraft.font;
        int marginY = 32;
        int marginX = 40;
        int center = this.minecraft.getWindow().getGuiScaledWidth() / 2;
        int leftButtonX = center - 150 - 3;
        int rightButtonX = center + 3;
        Objects.requireNonNull(font);
        int y = 32 + 9 * 2;
        this.addRenderableOnly(new LabelLine(font, 40, y, this.width - 80, (Component)Component.translatable((String)"colorfulhearts.screen.configuration.colors.category")));
        Objects.requireNonNull(font);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.health_colors"), btn -> this.minecraft.setScreen((Screen)new ColorSelectionScreen(this, true))).pos(leftButtonX, y += 9 * 2).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"colorfulhearts.options.button.absorption_colors"), btn -> this.minecraft.setScreen((Screen)new ColorSelectionScreen(this, false))).pos(rightButtonX, y).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 27, 200, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.lastScreen);
    }
}

