/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.colorfulallays;

import com.breakinblocks.colorfulallays.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="colorfulallays")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue ENABLE_NATURAL_SPAWNING;
    private static final ModConfigSpec.ConfigValue<Integer> NATURAL_SPAWN_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> NATURAL_SPAWN_MIN_GROUP;
    private static final ModConfigSpec.ConfigValue<Integer> NATURAL_SPAWN_MAX_GROUP;
    private static final ModConfigSpec.BooleanValue ENABLE_INTERACTION_PERSISTENCE;
    private static final ModConfigSpec.BooleanValue ENABLE_RANDOM_SPAWNING;
    private static final ModConfigSpec.ConfigValue<Integer> WHITE_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> ORANGE_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> MAGENTA_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> LIGHT_BLUE_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> YELLOW_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> LIME_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> PINK_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> GRAY_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> LIGHT_GRAY_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> CYAN_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> PURPLE_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> BLUE_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> BROWN_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> GREEN_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> RED_WEIGHT;
    private static final ModConfigSpec.ConfigValue<Integer> BLACK_WEIGHT;
    static final ModConfigSpec SPEC;
    public static boolean enableRandomSpawning;
    public static boolean enableNaturalSpawning;
    public static int naturalSpawnWeight;
    public static int naturalSpawnMinGroup;
    public static int naturalSpawnMaxGroup;
    public static boolean enableInteractionPersistence;
    public static Map<DyeColor, Integer> colorWeights;

    private static ModConfigSpec.ConfigValue<Integer> defineWeight(String name, int defaultValue) {
        return BUILDER.define(name, (Object)defaultValue, value -> value instanceof Integer && (Integer)value >= 0 && (Integer)value <= 1000);
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        enableRandomSpawning = (Boolean)ENABLE_RANDOM_SPAWNING.get();
        enableNaturalSpawning = (Boolean)ENABLE_NATURAL_SPAWNING.get();
        naturalSpawnWeight = (Integer)NATURAL_SPAWN_WEIGHT.get();
        naturalSpawnMinGroup = (Integer)NATURAL_SPAWN_MIN_GROUP.get();
        naturalSpawnMaxGroup = (Integer)NATURAL_SPAWN_MAX_GROUP.get();
        enableInteractionPersistence = (Boolean)ENABLE_INTERACTION_PERSISTENCE.get();
        colorWeights.put(DyeColor.WHITE, (Integer)WHITE_WEIGHT.get());
        colorWeights.put(DyeColor.ORANGE, (Integer)ORANGE_WEIGHT.get());
        colorWeights.put(DyeColor.MAGENTA, (Integer)MAGENTA_WEIGHT.get());
        colorWeights.put(DyeColor.LIGHT_BLUE, (Integer)LIGHT_BLUE_WEIGHT.get());
        colorWeights.put(DyeColor.YELLOW, (Integer)YELLOW_WEIGHT.get());
        colorWeights.put(DyeColor.LIME, (Integer)LIME_WEIGHT.get());
        colorWeights.put(DyeColor.PINK, (Integer)PINK_WEIGHT.get());
        colorWeights.put(DyeColor.GRAY, (Integer)GRAY_WEIGHT.get());
        colorWeights.put(DyeColor.LIGHT_GRAY, (Integer)LIGHT_GRAY_WEIGHT.get());
        colorWeights.put(DyeColor.CYAN, (Integer)CYAN_WEIGHT.get());
        colorWeights.put(DyeColor.PURPLE, (Integer)PURPLE_WEIGHT.get());
        colorWeights.put(DyeColor.BLUE, (Integer)BLUE_WEIGHT.get());
        colorWeights.put(DyeColor.BROWN, (Integer)BROWN_WEIGHT.get());
        colorWeights.put(DyeColor.GREEN, (Integer)GREEN_WEIGHT.get());
        colorWeights.put(DyeColor.RED, (Integer)RED_WEIGHT.get());
        colorWeights.put(DyeColor.BLACK, (Integer)BLACK_WEIGHT.get());
        Utils.updateCachedWeight();
    }

    static {
        BUILDER.comment("Natural spawning configuration for Allays").push("spawning");
        ENABLE_NATURAL_SPAWNING = BUILDER.comment("Enable natural spawning of Allays in the world").define("enableNaturalSpawning", true);
        NATURAL_SPAWN_WEIGHT = BUILDER.comment("Weight for natural Allay spawning (higher = more common, 0 = disabled)").define("naturalSpawnWeight", (Object)5, value -> value instanceof Integer && (Integer)value >= 0 && (Integer)value <= 100);
        NATURAL_SPAWN_MIN_GROUP = BUILDER.comment("Minimum group size for natural Allay spawning").define("naturalSpawnMinGroup", (Object)1, value -> value instanceof Integer && (Integer)value >= 1 && (Integer)value <= 10);
        NATURAL_SPAWN_MAX_GROUP = BUILDER.comment("Maximum group size for natural Allay spawning").define("naturalSpawnMaxGroup", (Object)2, value -> value instanceof Integer && (Integer)value >= 1 && (Integer)value <= 10);
        ENABLE_INTERACTION_PERSISTENCE = BUILDER.comment("Make naturally spawned Allays persistent when a player interacts with them").define("enableInteractionPersistence", true);
        BUILDER.pop();
        BUILDER.comment("Color randomization settings").push("colors");
        ENABLE_RANDOM_SPAWNING = BUILDER.comment("Enable random color assignment when Allays spawn naturally").define("enableRandomColorSpawning", true);
        BUILDER.comment("Color weights: higher values = more common spawns (0 = disabled, max 1000)").push("weights");
        WHITE_WEIGHT = Config.defineWeight("white", 10);
        ORANGE_WEIGHT = Config.defineWeight("orange", 8);
        MAGENTA_WEIGHT = Config.defineWeight("magenta", 6);
        LIGHT_BLUE_WEIGHT = Config.defineWeight("lightBlue", 15);
        YELLOW_WEIGHT = Config.defineWeight("yellow", 8);
        LIME_WEIGHT = Config.defineWeight("lime", 7);
        PINK_WEIGHT = Config.defineWeight("pink", 8);
        GRAY_WEIGHT = Config.defineWeight("gray", 5);
        LIGHT_GRAY_WEIGHT = Config.defineWeight("lightGray", 7);
        CYAN_WEIGHT = Config.defineWeight("cyan", 6);
        PURPLE_WEIGHT = Config.defineWeight("purple", 5);
        BLUE_WEIGHT = Config.defineWeight("blue", 8);
        BROWN_WEIGHT = Config.defineWeight("brown", 4);
        GREEN_WEIGHT = Config.defineWeight("green", 6);
        RED_WEIGHT = Config.defineWeight("red", 7);
        BLACK_WEIGHT = Config.defineWeight("black", 3);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
        colorWeights = new HashMap<DyeColor, Integer>();
    }
}

