/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class FluidInPipe {
    public static final Codec<FluidInPipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("amount").orElse((Object)0).forGetter(FluidInPipe::getAmount), (App)Codec.SHORT.fieldOf("speed").orElse((Object)0).forGetter(FluidInPipe::getSpeed), (App)Codec.SHORT.fieldOf("progress").orElse((Object)0).forGetter(FluidInPipe::getProgress), (App)Codec.BYTE.fieldOf("from_direction").orElse((Object)0).forGetter(fluidPacket -> (byte)fluidPacket.getFromDirection().get3DDataValue()), (App)Codec.BYTE.fieldOf("target_direction").orElse((Object)0).forGetter(fluidPacket -> (byte)fluidPacket.getTargetDirection().get3DDataValue()), (App)Codec.SHORT.fieldOf("age").orElse((Object)0).forGetter(FluidInPipe::getAge)).apply((Applicative)instance, FluidInPipe::new));
    private int amount;
    private short speed;
    private short progress;
    private Direction fromDirection;
    private Direction targetDirection;
    private short age;

    public FluidInPipe(int amount, short speed, short progress, Direction fromDirection, Direction targetDirection, short age) {
        this.amount = amount;
        this.speed = speed;
        this.progress = progress;
        this.fromDirection = fromDirection;
        this.targetDirection = targetDirection;
        this.age = age;
    }

    public FluidInPipe(int amount, short speed, short progress, byte fromDirection, byte targetDirection, short age) {
        this(amount, speed, progress, Direction.from3DDataValue((int)fromDirection), Direction.from3DDataValue((int)targetDirection), age);
    }

    public void move(short targetSpeed, short acceleration) {
        if (this.speed < targetSpeed) {
            this.speed = (short)Math.min(this.speed + acceleration, Math.min(targetSpeed, 1024));
        } else if (this.speed > targetSpeed) {
            this.speed = (short)Math.max(this.speed - acceleration, Math.max(targetSpeed, 1));
        }
        this.progress = (short)(this.progress + this.speed);
        this.age = (short)(this.age + 1);
    }

    public Vec3 getDebugRenderPosition(float partialTicks) {
        Direction d;
        float p = (float)this.progress / 2048.0f + partialTicks * (float)this.speed / 2048.0f;
        float q = 1.0f - p;
        boolean h = p < 0.5f;
        Direction direction = d = h ? this.fromDirection : this.targetDirection;
        return new Vec3(d == Direction.WEST ? (double)(h ? p : q) : (double)(d == Direction.EAST ? (h ? q : p) : 0.5f), d == Direction.DOWN ? (double)(h ? p : q) : (double)(d == Direction.UP ? (h ? q : p) : 0.5f), d == Direction.NORTH ? (double)(h ? p : q) : (double)(d == Direction.SOUTH ? (h ? q : p) : 0.5f));
    }

    public void resetProgress(Direction direction) {
        this.progress = (short)(this.progress - 2048);
        this.fromDirection = direction;
        this.targetDirection = direction;
    }

    public FluidInPipe copyWithAmount(int amount) {
        return new FluidInPipe(amount, this.speed, this.progress, this.fromDirection, this.targetDirection, this.age);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public short getSpeed() {
        return this.speed;
    }

    public short getProgress() {
        return this.progress;
    }

    public Direction getFromDirection() {
        return this.fromDirection;
    }

    public Direction getTargetDirection() {
        return this.targetDirection;
    }

    public void setTargetDirection(Direction targetDirection) {
        this.targetDirection = targetDirection;
    }

    public short getAge() {
        return this.age;
    }
}

