/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.ContainerAdjacentNetworkedPipeBlock;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.StoragePipeEntity;
import jagm.classicpipes.network.ClientBoundThreeBoolsPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class StoragePipeBlock
extends ContainerAdjacentNetworkedPipeBlock {
    public StoragePipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StoragePipeEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.STORAGE_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (super.useWithoutItem(state, level, pos, player, hitResult).equals((Object)InteractionResult.SUCCESS)) {
            return InteractionResult.SUCCESS;
        }
        if (level instanceof ServerLevel && (blockEntity = level.getBlockEntity(pos)) instanceof StoragePipeEntity) {
            StoragePipeEntity storagePipe = (StoragePipeEntity)blockEntity;
            Services.LOADER_SERVICE.openMenu((ServerPlayer)player, storagePipe, new ClientBoundThreeBoolsPayload(storagePipe.isDefaultRoute(), storagePipe.shouldMatchComponents(), storagePipe.shouldLeaveOne()), ClientBoundThreeBoolsPayload.STREAM_CODEC);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity;
        Direction facing = ((FacingOrNone)((Object)state.getValue((Property)FACING))).getDirection();
        if (level instanceof ServerLevel && facing != null && (blockEntity = level.getBlockEntity(pos)) instanceof StoragePipeEntity) {
            StoragePipeEntity storagePipe = (StoragePipeEntity)blockEntity;
            if (neighbor.equals((Object)pos.relative(facing))) {
                storagePipe.updateCache();
            }
        }
    }
}

