/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.network.server;

import com.leclowndu93150.chisel.network.AutoChiselFXPayload;
import com.leclowndu93150.chisel.network.ChunkDataPayload;
import com.leclowndu93150.chisel.network.client.ClientPayloadHandler;
import com.leclowndu93150.chisel.network.server.ChiselButtonPayload;
import com.leclowndu93150.chisel.network.server.ChiselModePayload;
import com.leclowndu93150.chisel.network.server.HitechSettingsPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="chisel", bus=EventBusSubscriber.Bus.MOD)
public class ChiselNetwork {
    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("chisel").versioned("1.0.0");
        registrar.playToServer(ChiselModePayload.TYPE, ChiselModePayload.STREAM_CODEC, ChiselModePayload::handle);
        registrar.playToServer(ChiselButtonPayload.TYPE, ChiselButtonPayload.STREAM_CODEC, ChiselButtonPayload::handle);
        registrar.playToServer(HitechSettingsPayload.TYPE, HitechSettingsPayload.STREAM_CODEC, HitechSettingsPayload::handle);
        registrar.playToClient(AutoChiselFXPayload.TYPE, AutoChiselFXPayload.STREAM_CODEC, FMLEnvironment.dist.isClient() ? ClientHandlers.autoChiselFX() : (p, c) -> {});
        registrar.playToClient(ChunkDataPayload.TYPE, ChunkDataPayload.STREAM_CODEC, FMLEnvironment.dist.isClient() ? ClientHandlers.chunkData() : (p, c) -> {});
    }

    private static class ClientHandlers {
        private ClientHandlers() {
        }

        static IPayloadHandler<AutoChiselFXPayload> autoChiselFX() {
            return ClientPayloadHandler::handleAutoChiselFX;
        }

        static IPayloadHandler<ChunkDataPayload> chunkData() {
            return ClientPayloadHandler::handleChunkData;
        }
    }
}

