/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.api.block;

import com.leclowndu93150.chisel.data.ChiselModelTemplates;
import javax.annotation.Nullable;

public record VariationData(String name, String localizedName, @Nullable ChiselModelTemplates.ModelTemplate modelTemplate, @Nullable String[] tooltip, @Nullable String textureOverride) {
    public VariationData(String name) {
        this(name, VariationData.toTitleCase(name), null, null, null);
    }

    public VariationData(String name, String localizedName) {
        this(name, localizedName, null, null, null);
    }

    public VariationData(String name, ChiselModelTemplates.ModelTemplate modelTemplate) {
        this(name, VariationData.toTitleCase(name), modelTemplate, null, null);
    }

    public VariationData(String name, String localizedName, ChiselModelTemplates.ModelTemplate modelTemplate) {
        this(name, localizedName, modelTemplate, null, null);
    }

    public VariationData(String name, String localizedName, ChiselModelTemplates.ModelTemplate modelTemplate, @Nullable String[] tooltip) {
        this(name, localizedName, modelTemplate, tooltip, null);
    }

    public VariationData withTooltip(String ... tooltip) {
        return new VariationData(this.name, this.localizedName, this.modelTemplate, tooltip, this.textureOverride);
    }

    public VariationData withModelTemplate(ChiselModelTemplates.ModelTemplate template) {
        return new VariationData(this.name, this.localizedName, template, this.tooltip, this.textureOverride);
    }

    public VariationData withName(String newLocalizedName) {
        return new VariationData(this.name, newLocalizedName, this.modelTemplate, this.tooltip, this.textureOverride);
    }

    public VariationData withTexture(String textureName) {
        return new VariationData(this.name, this.localizedName, this.modelTemplate, this.tooltip, textureName);
    }

    public String getTextureName() {
        return this.textureOverride != null ? this.textureOverride : this.name;
    }

    private static String toTitleCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (c == '_' || c == ' ' || c == '/') {
                result.append(' ');
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

