/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup;

import com.mojang.serialization.Codec;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;

@EventBusSubscriber(modid="bonsaitrees4")
public class ModDataPacks {
    private static final PackSelectionConfig REQUIRED_SELECTION_CONFIG = new PackSelectionConfig(true, Pack.Position.BOTTOM, false);
    private static final PackSelectionConfig OPTIONAL_SELECTION_CONFIG = new PackSelectionConfig(false, Pack.Position.BOTTOM, false);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static void addPackFinder(AddPackFindersEvent event) {
        IModFile bonsaiModFile = ModList.get().getModFileById("bonsaitrees4").getFile();
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path datapacksPath = bonsaiModFile.findResource(new String[]{"datapacks"});
            try (Stream<Path> paths = Files.walk(datapacksPath, new FileVisitOption[0]);){
                for (Path path : paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.naturalOrder()).toList()) {
                    String modId = path.getFileName().toString();
                    IModFileInfo modFile = ModList.get().getModFileById(modId);
                    PackSelectionConfig selectionConfig = modFile == null ? OPTIONAL_SELECTION_CONFIG : REQUIRED_SELECTION_CONFIG;
                    PackLocationInfo packLocationInfo = new PackLocationInfo(modId, (Component)Component.literal((String)("Bonsais: " + modId)), PackSource.BUILT_IN, Optional.empty());
                    PathPackResources packResources = new PathPackResources(packLocationInfo, path);
                    PackMetadataSection packMeta = (PackMetadataSection)packResources.getMetadataSection((MetadataSectionSerializer)MetadataSectionType.fromCodec((String)"pack", (Codec)PackMetadataSection.CODEC));
                    if (packMeta == null) continue;
                    PathPackResources.PathResourcesSupplier pathResourcesSupplier = new PathPackResources.PathResourcesSupplier(path);
                    Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)pathResourcesSupplier, (PackType)event.getPackType(), (PackSelectionConfig)selectionConfig);
                    event.addRepositorySource(consumer -> consumer.accept(pack));
                }
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (event.getPackType() != PackType.CLIENT_RESOURCES) return;
        Path resourcePath = bonsaiModFile.findResource(new String[]{"resourcepacks"});
        try (Stream<Path> paths = Files.walk(resourcePath, new FileVisitOption[0]);){
            for (Path path : paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.naturalOrder()).toList()) {
                String modId = path.getFileName().toString();
                IModFileInfo modFile = ModList.get().getModFileById(modId);
                PackSelectionConfig selectionConfig = modFile == null ? OPTIONAL_SELECTION_CONFIG : REQUIRED_SELECTION_CONFIG;
                PackLocationInfo packLocationInfo = new PackLocationInfo(modId, (Component)Component.literal((String)("Bonsais: " + modId)), PackSource.BUILT_IN, Optional.empty());
                PathPackResources packInfo = new PathPackResources(packLocationInfo, path);
                try {
                    PackMetadataSection packMeta = (PackMetadataSection)packInfo.getMetadataSection((MetadataSectionSerializer)MetadataSectionType.fromCodec((String)"pack", (Codec)PackMetadataSection.CODEC));
                    if (packMeta == null) continue;
                    event.addRepositorySource(consumer -> consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(path), (PackType)event.getPackType(), (PackSelectionConfig)selectionConfig)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

