/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.blocks;

import com.davenonymous.bonsaitrees.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees.blocks.BonsaiPotContainer;
import com.davenonymous.bonsaitrees.lib.gui.GUI;
import com.davenonymous.bonsaitrees.lib.gui.RedstoneMode;
import com.davenonymous.bonsaitrees.lib.gui.WidgetContainer;
import com.davenonymous.bonsaitrees.lib.gui.WidgetContainerScreen;
import com.davenonymous.bonsaitrees.lib.gui.event.GuiDataUpdatedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.UpdateScreenEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.ValueChangedEvent;
import com.davenonymous.bonsaitrees.lib.gui.event.WidgetEventResult;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.IngredientBoxTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.ItemStackTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.StringTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.TranslatableTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.VBoxTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.tooltip.WrappedStringTooltipComponent;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetItemStack;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetProgressArrow;
import com.davenonymous.bonsaitrees.lib.gui.widgets.WidgetRedstoneMode;
import com.davenonymous.bonsaitrees.networking.SetRedstoneMode;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class BonsaiPotScreen
extends WidgetContainerScreen<BonsaiPotContainer> {
    private List<Item> allSoilsSorted;

    public BonsaiPotScreen(BonsaiPotContainer container, Inventory inv, Component name) {
        super(container, inv, name);
    }

    @Override
    protected GUI createGUI() {
        GUI gui = new GUI(0, 0, BonsaiPotContainer.WIDTH, BonsaiPotContainer.HEIGHT);
        gui.setContainer((WidgetContainer)this.menu);
        BonsaiPotBlockEntity pot = (BonsaiPotBlockEntity)((Object)((BonsaiPotContainer)this.menu).getBlockEntity());
        this.allSoilsSorted = SoilCache.SOILS.keySet().stream().map(ItemStack::getItem).collect(Collectors.toSet()).stream().sorted(Comparator.comparing(item -> item.getDescriptionId(), Comparator.naturalOrder())).toList();
        if (pot != null) {
            BlockState potState = pot.getBlockState();
            Block potBlock = potState.getBlock();
            ItemEnchantments potEnchantments = pot.inventories.enchantments;
            StringBuilder titleKey = new StringBuilder(potBlock.getDescriptionId());
            if (!potEnchantments.isEmpty()) {
                titleKey.append(".enchanted");
            }
            this.setCustomTitle((Component)Component.translatable((String)titleKey.toString()));
        }
        WidgetProgressArrow progressArrow = new WidgetProgressArrow();
        progressArrow.setValue(0.0);
        progressArrow.setPosition(32, 40);
        gui.add(progressArrow);
        WidgetProgressArrow canProduceArrow = new WidgetProgressArrow();
        canProduceArrow.setValue(0.0);
        canProduceArrow.setPosition(86, 40);
        gui.add(canProduceArrow);
        WidgetItemStack fakeSapling = new WidgetItemStack(new ItemStack((ItemLike)Items.OAK_SAPLING), true);
        fakeSapling.setPosition(8, 20);
        fakeSapling.setVisible(false);
        fakeSapling.setGrayOut(true);
        fakeSapling.setDrawTooltip(false);
        fakeSapling.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.sapling_required"), new IngredientBoxTooltipComponent(BonsaiCache.BONSAI_BY_ITEM.keySet()));
        gui.add(fakeSapling);
        WidgetItemStack fakeSoil = new WidgetItemStack(new ItemStack((ItemLike)Items.GRASS_BLOCK), true);
        fakeSoil.setPosition(8, 40);
        fakeSoil.setVisible(false);
        fakeSoil.setGrayOut(true);
        fakeSoil.setDrawTooltip(false);
        fakeSoil.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.soil_required"), new IngredientBoxTooltipComponent(this.allSoilsSorted));
        gui.add(fakeSoil);
        WidgetItemStack fakeTool = new WidgetItemStack(new ItemStack((ItemLike)Items.IRON_AXE), true);
        fakeTool.setPosition(62, 40);
        fakeTool.setVisible(false);
        fakeTool.setGrayOut(true);
        fakeTool.setDrawTooltip(false);
        fakeTool.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.tool_required"));
        gui.add(fakeTool);
        WidgetItemStack fakeCamo = new WidgetItemStack(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK), true);
        fakeCamo.setPosition(8, 60);
        fakeCamo.setVisible(false);
        fakeCamo.setGrayOut(true);
        fakeCamo.setDrawTooltip(false);
        fakeCamo.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.camouflage_optional"));
        gui.add(fakeCamo);
        WidgetItemStack fakeEnchantment = new WidgetItemStack(new ItemStack((ItemLike)Items.BOOK), false);
        fakeEnchantment.setPosition(62, 60);
        fakeEnchantment.setVisible(false);
        fakeEnchantment.setGrayOut(true);
        fakeEnchantment.setDrawTooltip(false);
        fakeEnchantment.setTooltipElements(WrappedStringTooltipComponent.white(I18n.get((String)"bonsaitrees4.tooltip.enchantment_hint", (Object[])new Object[0])));
        gui.add(fakeEnchantment);
        WidgetItemStack enchantmentsDisplay = new WidgetItemStack(new ItemStack((ItemLike)Items.ENCHANTED_BOOK), false);
        enchantmentsDisplay.setPosition(62, 60);
        enchantmentsDisplay.setVisible(false);
        enchantmentsDisplay.setDrawTooltip(false);
        gui.add(enchantmentsDisplay);
        WidgetRedstoneMode redstoneModeToggle = new WidgetRedstoneMode(pot.getRedstoneMode());
        redstoneModeToggle.setPosition(BonsaiPotContainer.WIDTH - 20, 2);
        redstoneModeToggle.addListener(ValueChangedEvent.class, (event, widget) -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetRedstoneMode(pot.getBlockPos(), (RedstoneMode)((Object)((Object)redstoneModeToggle.getValue()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return WidgetEventResult.HANDLED;
        });
        gui.add(redstoneModeToggle);
        gui.addListener(GuiDataUpdatedEvent.class, (event, widget) -> {
            boolean isActive = pot.getRedstoneMode().resolve(pot.getLevel(), pot.getBlockPos());
            redstoneModeToggle.updateToolTips();
            redstoneModeToggle.addTooltipLine(new Component[]{isActive ? Component.translatable((String)"bonsaitrees4.tooltip.redstone_active").withStyle(ChatFormatting.DARK_GREEN) : Component.translatable((String)"bonsaitrees4.tooltip.redstone_inactive").withStyle(ChatFormatting.RED)});
            if (pot.inventories.enchantments.isEmpty()) {
                enchantmentsDisplay.setVisible(false);
                fakeEnchantment.setVisible(true);
            } else {
                enchantmentsDisplay.setVisible(true);
                fakeEnchantment.setVisible(false);
                enchantmentsDisplay.setTooltipLines(new Component[]{Component.translatable((String)"bonsaitrees4.tooltip.enchantments")});
                for (Holder enchantmentHolder : pot.inventories.enchantments.keySet()) {
                    int level = pot.inventories.enchantments.getLevel(enchantmentHolder);
                    MutableComponent description = ((Enchantment)enchantmentHolder.value()).description().copy().append(" ").append((Component)Component.translatable((String)("enchantment.level." + level)));
                    enchantmentsDisplay.addTooltipLine(new Component[]{description.withStyle(ChatFormatting.GRAY)});
                }
            }
            if (pot.inventories.getSaplingStack().isEmpty()) {
                fakeSapling.setVisible(true);
                fakeSoil.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.soil_required"), new IngredientBoxTooltipComponent(this.allSoilsSorted));
            } else {
                Optional<BonsaiInfo> bonsaiInfo = pot.production.getBonsaiInfo();
                if (bonsaiInfo.isPresent()) {
                    RegistryAccess registryAccess = pot.getLevel().registryAccess();
                    BonsaiInfo info = bonsaiInfo.get();
                    List<SoilType> validSoilTypes = info.validSoilTypes(registryAccess);
                    String joinedSoilNames = validSoilTypes.stream().map(type -> I18n.get((String)type.translationKey(), (Object[])new Object[0])).distinct().sorted().collect(Collectors.joining(", "));
                    VBoxTooltipComponent fakeSoilTooltip = new VBoxTooltipComponent(new TooltipComponent[0]).setPadding(2);
                    fakeSoilTooltip.add(new TranslatableTooltipComponent("bonsaitrees4.tooltip.valid_soils"), new IngredientBoxTooltipComponent(info.validSoilItems(registryAccess)), StringTooltipComponent.gray(joinedSoilNames));
                    fakeSoil.setTooltipElements(fakeSoilTooltip);
                }
                fakeSapling.setVisible(false);
            }
            if (pot.inventories.getSoilStack().isEmpty()) {
                fakeSoil.setVisible(true);
                fakeSapling.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.sapling_required"), new IngredientBoxTooltipComponent(BonsaiCache.BONSAI_BY_ITEM.keySet()));
            } else {
                fakeSoil.setVisible(false);
                Optional<Set<SoilInfo>> soilInfos = pot.production.getSoilInfo();
                if (soilInfos.isPresent()) {
                    HashSet<Item> validBonsais = new HashSet<Item>();
                    for (SoilInfo soilInfo : soilInfos.get()) {
                        for (ResourceLocation soilTypeId : soilInfo.soilType()) {
                            Set<Item> matchingBonsais = SoilCache.BONSAIS_BY_SOIL.get(soilTypeId);
                            if (matchingBonsais == null) continue;
                            validBonsais.addAll(matchingBonsais);
                        }
                    }
                    if (validBonsais.isEmpty()) {
                        fakeSapling.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.no_valid_saplings"));
                    } else {
                        fakeSapling.setTooltipElements(new TranslatableTooltipComponent("bonsaitrees4.tooltip.valid_saplings"), new IngredientBoxTooltipComponent(validBonsais));
                    }
                }
            }
            if (pot.inventories.getCamouflageStack().isEmpty()) {
                fakeCamo.setVisible(true);
            } else {
                fakeCamo.setVisible(false);
            }
            if (pot.inventories.getToolStack().isEmpty()) {
                canProduceArrow.setValue(0.0);
                fakeTool.setVisible(true);
            } else {
                canProduceArrow.setValue(100.0);
                fakeTool.setVisible(false);
            }
            progressArrow.setDisabled(!pot.production.canGrow());
            if (!pot.production.lootQueue.isEmpty()) {
                VBoxTooltipComponent lootQueueItemBox = new VBoxTooltipComponent(new TooltipComponent[0]).setPadding(3);
                for (ItemStack lootItem : pot.production.lootQueue) {
                    lootQueueItemBox.add(new ItemStackTooltipComponent(lootItem).setShowLabel(true).setLabelColor(ChatFormatting.WHITE));
                }
                canProduceArrow.setTooltipElements(WrappedStringTooltipComponent.warn(I18n.get((String)"bonsaitrees4.tooltip.unable_to_insert", (Object[])new Object[0])), WrappedStringTooltipComponent.warn(I18n.get((String)"bonsaitrees4.tooltip.production_on_hold", (Object[])new Object[0])), lootQueueItemBox);
                canProduceArrow.setDisabled(true);
            } else {
                canProduceArrow.setTooltipElements(new TooltipComponent[0]);
                canProduceArrow.setDisabled(false);
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.fireDataUpdateEvent();
        gui.addListener(UpdateScreenEvent.class, (event, widget) -> {
            progressArrow.setValue((double)pot.getTreeGrowthProgress(0.0f) * 100.0);
            if ((Double)progressArrow.getValue() > 0.0) {
                progressArrow.setTooltipLines(new Component[]{Component.literal((String)String.format("%.0f%%", progressArrow.getValue()))});
            } else {
                progressArrow.setTooltipLines(Collections.emptyList());
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        return gui;
    }
}

