/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.ricmc.betterblockz.component.ModDataComponents;
import org.jetbrains.annotations.NotNull;

public class MetaWandItem
extends Item {
    private final List<Item> wandItems;

    public MetaWandItem(List<Item> wandItems, Item.Properties properties) {
        super(properties);
        this.wandItems = wandItems;
    }

    public Item getCurrentWand(ItemStack stack) {
        int index = Optional.ofNullable((Integer)stack.get(ModDataComponents.STORED_WAND_TYPE_INDEX)).orElse(0);
        if (index < 0 || index >= this.wandItems.size()) {
            index = 0;
            stack.set(ModDataComponents.STORED_WAND_TYPE_INDEX, (Object)index);
        }
        return this.wandItems.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        InteractionResultHolder result;
        ItemStack metaStack = player.getItemInHand(hand);
        Item current = this.getCurrentWand(metaStack);
        ItemStack wandStack = new ItemStack((ItemLike)current);
        this.copyAllComponents(metaStack, wandStack);
        player.setItemInHand(hand, wandStack);
        try {
            result = current.use(level, player, hand);
        }
        finally {
            player.setItemInHand(hand, metaStack);
        }
        this.copyAllComponents(wandStack, metaStack);
        return new InteractionResultHolder(result.getResult(), (Object)metaStack);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack metaStack = context.getItemInHand();
        Item current = this.getCurrentWand(metaStack);
        ItemStack wandStack = new ItemStack((ItemLike)current);
        this.copyAllComponents(metaStack, wandStack);
        BlockHitResult hitResult = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside());
        UseOnContext wandContext = new UseOnContext(context.getLevel(), context.getPlayer(), context.getHand(), wandStack, hitResult);
        InteractionResult result = current.useOn(wandContext);
        this.copyAllComponents(wandStack, metaStack);
        return result;
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        if (player.level().isClientSide) {
            return false;
        }
        int slot = player.getInventory().selected;
        int index = Optional.ofNullable((Integer)stack.get(ModDataComponents.STORED_WAND_TYPE_INDEX)).orElse(0);
        index = (index + 1) % this.wandItems.size();
        stack.set(ModDataComponents.STORED_WAND_TYPE_INDEX, (Object)index);
        player.getInventory().setItem(slot, stack);
        player.displayClientMessage((Component)Component.literal((String)("Switched to: " + this.wandItems.get(index).getName(stack).getString())), true);
        player.level().playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.8f, 1.0f);
        return false;
    }

    private void copyAllComponents(ItemStack from, ItemStack to) {
        ModDataComponents.DATA_COMPONENT_TYPES.getEntries().forEach(entry -> this.copyComponent(from, to, (DataComponentType)entry.get()));
    }

    private <T> void copyComponent(ItemStack from, ItemStack to, DataComponentType<T> type) {
        if (from.has(type)) {
            Object value = from.get(type);
            to.set(type, value);
        }
    }

    public Component getName(ItemStack stack) {
        Item current = this.getCurrentWand(stack);
        MutableComponent base = Component.translatable((String)this.getDescriptionId(stack));
        String currentName = current.getName(new ItemStack((ItemLike)current)).getString();
        if (currentName.startsWith("BlockZ ")) {
            currentName = currentName.substring("BlockZ ".length());
        }
        return Component.literal((String)(base.getString() + ": " + currentName));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Item current = this.getCurrentWand(stack);
        String baseKey = current.getDescriptionId();
        tooltip.add((Component)Component.literal((String)"\u00a77Press \u00a7eQ\u00a77 (drop) to \u00a7aCycle Wands\u00a7r"));
        tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        if (Screen.hasShiftDown()) {
            for (int i = 1; i <= 6; ++i) {
                String key = baseKey + ".shift.line" + i;
                if (!Language.getInstance().has(key)) break;
                tooltip.add((Component)Component.translatable((String)key));
            }
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

