/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FloaterBlockItem
extends BlockItem {
    public FloaterBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        double reach = 5.0;
        Vec3 eye = player.getEyePosition();
        Vec3 look = player.getLookAngle();
        Vec3 end = eye.add(look.scale(reach));
        BlockHitResult hit = level.clip(new ClipContext(eye, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos placePos = null;
        if (hit.getType() == HitResult.Type.BLOCK) {
            BlockHitResult bhr = hit;
            placePos = bhr.getBlockPos().relative(bhr.getDirection());
        } else if (hit.getType() == HitResult.Type.MISS) {
            BlockPos candidate = BlockPos.containing((Position)end);
            for (int y = -2; y <= 2; ++y) {
                BlockPos pos = candidate.offset(0, y, 0);
                if (!level.isEmptyBlock(pos)) continue;
                placePos = pos;
                break;
            }
        }
        if (placePos == null || !level.isEmptyBlock(placePos)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        BlockState state = this.getBlock().defaultBlockState();
        level.setBlock(placePos, state, 3);
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

